<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeSetFactory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageTypeSet;

defined('_JEXEC') or die;

/**
* @var ImageTypeSetFactory $imagetypesetFactory
*/
$imagetypesetFactory = ImageTypeSetFactory::getInstance();
$imagetypesets = $imagetypesetFactory->getImageTypeSets(true);

$return = '<label id="batch-imagetypeset-lbl" for="batch-imagetypeset" class="hasToolip">'
    . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_IMAGETYPESET_LABEL')
    . '</label>';

$return .= '<select name="batch[imagetypeset]" id="batch-imagetypeset" class="inputbox form-select">';
$return .= '<option  value="">'.\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_IMAGETYPESET_KEEP').'</option>';

foreach($imagetypesets as $imagetypeset) {
    /**
    * @var ImageTypeSet $imagetypeset
    */
    $return .= '<option  value="'.$imagetypeset->getId().'">'.$imagetypeset->getName().'</option>';
}
$return .= "</select>";

echo $return;
