<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

$db = Factory::getDbo();
$query = $db->getQuery(true)
    ->select('a.id AS value')
    ->select('a.title AS text')
    ->select('COUNT(DISTINCT b.id) AS level')
    ->from('#__usergroups as a')
    ->join('LEFT', '#__usergroups  AS b ON a.lft > b.lft AND a.rgt < b.rgt')
    ->group('a.id, a.title, a.lft, a.rgt')
    ->order('a.lft ASC');
$db->setQuery($query);

if ($options = $db->loadObjectList()) {
    foreach ($options as $option) {
        $option->text = str_repeat('- ', $option->level) . $option->text;
    }
}

// Create the batch selector to change an access level on a selection list.
$return =
'<label id="batch-usergroup-lbl" for="batch-usergroup" class="hasToolip">'
. \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_USERGROUP_LABEL')
. '</label>';

$return .= '<select multiple="multiple" name="batch[usergroup][]" id="batch-usergroup" class="form-select inputbox">';
$return .= '<option  value="">'.\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_USERGROUP_KEEP').'</option>';

foreach($options as $option) {
    /**
    * @var Watermark $watermark
    */
    $return .= '<option value="'.$option->value.'">'.$option->text.'</option>';
}
$return .= "</select>";

echo $return;
