<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

use Svenbluege\Component\Eventgallery\Site\Library\Factory\WatermarkFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Watermark;

defined('_JEXEC') or die;
/**
* @var WatermarkFactory $watermarkFactory
*/
$watermarkFactory = WatermarkFactory::getInstance();
$watermarks = $watermarkFactory->getWatermarks(false);
?>

<label id="batch-watermark-lbl" for="batch-watermark">
<?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_WATERMARK_LABEL')?>
</label>

<select name="batch[watermark]" id="batch-watermark" class="inputbox form-select">';
    <option  value=""><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_BATCH_WATERMARK_KEEP') ?></option>
    <option  value="-1"><?php echo \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_WATERMARK_NONE') ?></option>

    <?php FOREACH($watermarks as $watermark): /* @var Watermark $watermark */ ?>
    <option value=" <?php echo $watermark->getId() ?>"><?php echo $watermark->getName() ?></option>
    <?php ENDFOREACH ?>
</select>

