<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

use Joomla\CMS\Categories\CategoryFactoryInterface;
use Joomla\CMS\Component\Router\RouterFactoryInterface;
use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\Extension\Service\Provider\CategoryFactory;
use Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory;
use Joomla\CMS\Extension\Service\Provider\MVCFactory;
use Joomla\CMS\Extension\Service\Provider\RouterFactory;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\Component\Fields\Administrator\Extension\FieldsComponent;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Svenbluege\Component\Eventgallery\Administrator\Extension\EventgalleryComponent;
/**
 * The tags service provider.
 *
 * @since  4.0.0
 */
return new class implements ServiceProviderInterface
{
    /**
     * Registers the service provider with a DI container.
     *
     * @param   Container  $container  The DI container.
     *
     * @return  void
     *
     * @since   4.0.0
     */
    public function register(Container $container)
    {
        $container->registerServiceProvider(new CategoryFactory('\\Svenbluege\\Component\\Eventgallery'));
        $container->registerServiceProvider(new MVCFactory('\\Svenbluege\\Component\\Eventgallery'));
        $container->registerServiceProvider(new ComponentDispatcherFactory('\\Svenbluege\\Component\\Eventgallery'));
        $container->registerServiceProvider(new RouterFactory('\\Svenbluege\\Component\\Eventgallery'));
        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new EventgalleryComponent($container->get(ComponentDispatcherFactoryInterface::class));
                $component->setMVCFactory($container->get(MVCFactoryInterface::class));
                $component->setRouterFactory($container->get(RouterFactoryInterface::class));
                $component->setCategoryFactory($container->get(CategoryFactoryInterface::class));
                return $component;
            }
        );
    }
};
