<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Session\Session;

defined('_JEXEC') or die;

class CacheController extends FormController
{

    /**
     * The root folder for the physical images
     *
     * @var string
     */

    protected $default_view = 'cache';

    /**
     * just cancels this view
     * @param null $key
     * @return bool|void
     */
	public function cancel($key = NULL) {
		$this->setRedirect( 'index.php?option=com_eventgallery&view=eventgallery');
	}

    /**
     * starts the deletion.
     *
     * @param bool $cachable
     * @param array $urlparams
     * * @param array $urlparams
     */
    public function process(/** @noinspection PhpUnusedParameterInspection */$cachable = false, $urlparams = array()) {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

        $folder = trim($this->input->getString('images',''));
        $googlephotos = $this->input->getString('googlephotos', '');
        $googlephotossharedpage = $this->input->getString('googlephotossharedpage', '');
        $flickr = $this->input->getString('flickr', '');
        $general = $this->input->getString('general', '');

        if (!empty($folder)) {
            $this->getModel()->clearImageCacheFolder($folder);
        }

        if (!empty($googlephotos)) {
            $this->getModel()->clearGooglePhotosCacheFolder();
        }

        if (!empty($googlephotossharedpage)) {
            $this->getModel()->clearGooglePhotosSharedPageCacheFolder();
        }

        if (!empty($flickr)) {
            $this->getModel()->clearFlickrCacheFolder();
        }

        if (!empty($general)) {
            $this->getModel()->clearGeneralCacheFolder();
        }

        echo '{"result:"done"}';

    }


}
