<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\MVC\Controller\AdminController;
use Svenbluege\Component\Eventgallery\Administrator\Library\Csv\CsvEntry;
use Svenbluege\Component\Eventgallery\Site\Library\Common\Downloadlog;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;

defined('_JEXEC') or die('Restricted access');

class DownloadlogController extends AdminController
{

    protected $default_view = 'downloadlog';

    public function export() {
        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();

        $model = $this->getModel();
        $state = $model->getState();
        $items = $model->getItems();

        $filenameParts = ["downloadlog_export"];
        $filenameParts[] = "type_".$model->getState('filter.type');
        $filenameParts[] = "usertype_".$model->getState('filter.usertype');
        $filenameParts[] = "year_".$model->getState('filter.year');
        $filenameParts[] = "month_".$model->getState('filter.month');
        $filenameParts[] = "start_".$model->getState('list.start');
        $filenameParts[] = "limit_".$model->getState('list.limit');

        $filename = implode('-', $filenameParts).".csv";

        header("Cache-Control: no-cache, must-revalidate"); //HTTP 1.1
        header("Pragma: no-cache"); //HTTP 1.0
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="'.$filename.'"');

        $fp = fopen('php://output', 'wb');
        fputcsv($fp, CsvEntry::getCSVHeadline());

        /**
         * @var CsvEntry[] $entries;
         */
        $entries = [];

        foreach($items as $item) {
            $joomlaUserId = "";
            $joomlaUserEmail = "";

            if (is_numeric($item->juserid)) {
                $user = \Joomla\CMS\Factory::getUser($item->juserid);
                $joomlaUserId = $user->id;
                $joomlaUserEmail = $user->email;
            }

            $orderId = "";
            $orderEmail = "";
            if ($item->type == Downloadlog::TYPE_PURCHASE_FILE) {
                $order = $orderFactory->getOrderById($item->reference);
                if ($order != null) {
                    $orderEmail = $order->getEMail();
                    $orderId = $order->getDocumentNumber();
                }
            }

            $entry = new CSVEntry(
                $item->folder,
                $item->file,
                $item->type,
                $item->isbot,
                $item->created,
                $joomlaUserId,
                $joomlaUserEmail,
                $orderId,
                $orderEmail
            );
            $entries[] = $entry;
        }

        foreach($entries as $key=>$entry) {
            fputcsv($fp, $entry->getCSVLine());
        }

        fclose($fp);

        die();
    }
}


