<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\EmailTemplateFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\EmailTemplateManager;
defined('_JEXEC') or die;

class EmailtemplateController extends FormController
{
    /**
     * sends a test mail to the current user by using the current emailtemplate and some demo data based on the emails key.
     *
     * @param null $key
     * @throws \Exception
     */
 	public function sendtestmail(/** @noinspection PhpUnusedParameterInspection */$key = NULL) {

        $app = Factory::getApplication();

 		$id = $this->input->getInt('id');

        if(!$id)
        {
            $this->setRedirect('index.php?option=com_eventgallery&view=emailtemplates', Text::_('COM_EVENTGALLERY_EMAILTEMPLATES_ERROR_CHOOSE_TEMPLATE'), 'notice');
            $this->redirect();
        }

        /**
        * @var EmailTemplateFactory $emailtemplateFactory
        * @var EmailTemplateManager $emailtemplateMgr
        */
        $emailtemplateFactory = EmailTemplateFactory::getInstance();
        $emailtemplateMgr = EmailTemplateManager::getInstance();

        $to = Factory::getUser()->email;

        $emailtemplate = $emailtemplateFactory->getEmailtemplateById($id);
        $data = $emailtemplateMgr->getDemoData($emailtemplate->getKey());

        $emailtemplateMgr->sendMailById($id, $data, Array($to), false );

 		$msg = Text::_('COM_EVENTGALLERY_EMAILTEMPLATE_TESTMAIL_SEND_SUCCESSFUL');
        $app->enqueueMessage($msg);
        $this->setRedirect( Route::_('index.php?option=com_eventgallery&view=emailtemplate&id='. $id. $this->getRedirectToListAppend(), false));
    }

}
