<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;
use Joomla\Filesystem\File;
use Svenbluege\Component\Eventgallery\Administrator\Model\EventModel;
use Svenbluege\Component\Eventgallery\Administrator\Table\FolderTable;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\LocalFolder;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\FolderManager;

defined('_JEXEC') or die;

/** @noinspection PhpUndefinedClassInspection */
class EventController extends FormController
{

	/**
	 * Method to save a record.
	 *
	 * @param   string  $key     The name of the primary key of the URL variable.
	 * @param   string  $urlVar  The name of the URL variable if different from the primary key (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if successful, false otherwise.
	 *
	 * @since   12.2
	 */
	public function save($key = null, $urlVar = null) {
		$task = $this->getTask();
		if ($task == 'save2copy') {
			$data  = $this->input->post->get('jform', array(), 'array');
			/**
			 * @var FolderFactory $folderFactory
			 */
			$folderFactory = FolderFactory::getInstance();
			$folder = $folderFactory->getFolder($data['folder']);

			if (null != $folder) {
				$this->setMessage(Text::_('COM_EVENTGALLERY_EVENT_COPY_ERROR'), 'error');

				$this->setRedirect(
					 Route::_(
						'index.php?option=' . $this->option . '&view=' . $this->view_item
						. $this->getRedirectToItemAppend($data['id'], 'id'), false
					)
				);

				return false;
			}
		}
		return parent::save($key, $urlVar);
	}


	/**
	 * Function that allows child controller access to model data after the data has been saved.
	 *
	 * param   $model      The data model object.
	 * param   array         $validData  The validated data.
	 *
	 * @return	void
	 * @since	1.6
	 */
	protected function postSaveHook(BaseDatabaseModel $model, $validData = array())
	{
        /**
         * @var EventModel $model
         */

        $oldFolder = $this->input->getString("oldfolder", null);
		$newFolder = $validData['folder'];

		# Rename folder now:
		$basedir = COM_EVENTGALLERY_IMAGE_FOLDER_PATH;

		if ($oldFolder!=null && strcmp($oldFolder, $newFolder)!=0 && $this->task != 'save2copy')
		{
			rename($basedir.$oldFolder, $basedir.$newFolder);
			$model->changeFolderName($oldFolder, $newFolder);
		}

		if ($this->task == 'save')
		{
			$this->setRedirect( Route::_('index.php?option=com_eventgallery&view=events', false));
		}
	}

	/**
	 * Method to run batch operations.
	 *
	 * @param   object  $model  The model.
	 *
	 * @return  boolean   True if successful, false otherwise and internal error is set.
	 *
	 * @since   2.5
	 */
	public function batch($model = null)
	{
		Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

		// Set the model
		$model = $this->getModel('Event', '', array());

		// Preset the redirect
		$this->setRedirect( Route::_('index.php?option=com_eventgallery&view=events' . $this->getRedirectToListAppend(), false));

        /** @noinspection PhpParamsInspection */
        return parent::batch($model);
	}

    public function resethits() {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));
        $folderid = $this->input->getInt('id');
        $model = $this->getModel('Event', '', array());

        $model->setHits($folderid, 0);
        $this->setMessage(Text::_('COM_EVENTGALLERY_EVENT_RESET_HITS_DONE'), 'info');
        $this->setRedirect(Route::_('index.php?option=' . $this->option . '&view=event&id=' . $folderid, false));
    }
}
