<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Log\Log;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\Utilities\ArrayHelper;

defined('_JEXEC') or die('Restricted access');

class EventsController extends AdminController
{

    public function __construct($config = array(), \Joomla\CMS\MVC\Factory\MVCFactoryInterface $factory = null, ?\Joomla\CMS\Application\CMSApplication $app = null, ?\Joomla\Input\Input $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
        $this->registerTask('notcartable', 'cartable');
        $this->registerTask('cartable', 'cartable');
    }

    public function getModel($name = 'Event', $prefix = '', $config = array())
    {
        return parent::getModel($name, $prefix, $config);
    }


    public function cartable() {
        $cid = Factory::getApplication()->input->get('cid', array(), 'array');
        $data = array('cartable' => 1, 'notcartable' => 0);
        $task = $this->getTask();
        $value = ArrayHelper::getValue($data, $task, 0, 'int');
        if (!is_array($cid) || count($cid) < 1)
        {
            Log::add(\Joomla\CMS\Language\Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
        }
        else
        {
            // Get the model.
            $model = $this->getModel();

            // Make sure the item ids are integers
            ArrayHelper::toInteger($cid);

            // Remove the items.
            if ($model->cartable($cid, $value))
            {
                if ($value == 1)
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_CARTABLE';
                }
                else
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_NOTCARTABLE';
                }
                $this->setMessage(\Joomla\CMS\Language\Text::plural($ntext, count($cid)));
            }
            else
            {
                $this->setMessage($model->getError());
            }
        }
        $this->setRedirect(Route::_('index.php?option=com_eventgallery&view=events', false));
    }
}
