<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

class FileController extends FormController
{

    protected function postSaveHook(BaseDatabaseModel $model, $validData = array())
	{
        if ($this->input->get('format') == 'raw') {
            if ($this->task == 'apply')
            {
                $this->setRedirect( Route::_('index.php?option=com_eventgallery&view=file&layout=edit&tmpl=component&format=raw&id='.$this->input->getInt('id') . $this->getRedirectToListAppend(), false));
            }

            if ($this->task == 'save')
            {
                $this->setRedirect( Route::_('index.php?option=com_eventgallery&view=file&layout=content&tmpl=component&format=raw&id='.$this->input->getInt('id') . $this->getRedirectToListAppend(), false));
            }
        } else {
            if ($this->task == 'save') {
                $this->setRedirect(Route::_('index.php?option=com_eventgallery&view=files&folderid=' . $this->input->getInt('folderid') . $this->getRedirectToListAppend(), false));
            }
        }
	}

    public function cancel($key = NULL) {
        $this->setRedirect( Route::_('index.php?option=com_eventgallery&view=files&folderid='.$this->input->getInt('folderid') . $this->getRedirectToListAppend(), false));
    }

}
