<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Session\Session;
use Joomla\Utilities\ArrayHelper;
use Svenbluege\Component\Eventgallery\Administrator\Model\FileModel;

defined('_JEXEC') or die('Restricted access');



class FilesController extends AdminController
{

    protected $_anchor = "";
    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;

    public function __construct($config = array(), \Joomla\CMS\MVC\Factory\MVCFactoryInterface $factory = null, \Joomla\CMS\Application\CMSApplication $app = null, \Joomla\Input\Input $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
        $cids = $this->input->post->get('cid', array(), 'array');
        if (isset($cids[0])) {
            $this->_anchor = '#'.$cids[0];
        }

        $this->registerTask('isnotmainimageonly', 'isMainImageOnly');
        $this->registerTask('ismainimageonly', 'isMainImageOnly');
        $this->registerTask('isnotmainimage', 'isMainImage');
        $this->registerTask('ismainimage', 'isMainImage');

        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
    }

    public function getModel($name = 'File', $prefix = '', $config = array())
    {
        return parent::getModel($name, $prefix, $config);
    }

    function cancel() {
        $this->setRedirect( 'index.php?option=com_eventgallery&view=events');
    }

    /**
     * function to publish a single file/multiple files
     *
     */
    function publish()
    {
       parent::publish();
       $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid').$this->_anchor);
    }

    function saveorder()
    {
        parent::saveorder();
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid'));
    }

    function reorder()
    {
        parent::reorder();
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid').$this->_anchor);
    }

    function delete()
    {
        parent::delete();
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid'));
    }

    function clearOrdering() {

        Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
        /**
         * @var FileModel $model
         */
        $model = $this->getModel();
        $model->clearOrdering($this->input->getString('folderid'));
        $msg = \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_EVENT_CLEAR_ORDERING_SUCCESS');
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid'), $msg);
    }

    function sort() {
        $sortAttribute = $this->input->getString('sortattribute');
        $sortDirection = $this->input->getString('sortdirection');

        if (empty($sortAttribute)) {
            $sortAttribute = $this->config->getEventsList()->getSortFilesByColumn();
        }
        if (empty($sortDirection)) {
            $sortDirection = $this->config->getEventsList()->getSortFilesByDirection();
        }

        $folderid = $this->input->getString('folderid');
        $model = $this->getModel();
        $affectedRows = $model->sort($folderid, $sortAttribute, $sortDirection);
        $msg = \Joomla\CMS\Language\Text::sprintf('COM_EVENTGALLERY_EVENT_ORDERING_SUCCESS', $sortAttribute, $sortDirection, $affectedRows);
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$folderid, $msg);
    }

    public function isMainImage() {
        $cid = Factory::getApplication()->input->get('cid', array(), 'array');
        $data = array('ismainimage' => 1, 'isnotmainimage' => 0);
        $task = $this->getTask();
        $value = ArrayHelper::getValue($data, $task, 0, 'int');
        if (!is_array($cid) || count($cid) < 1)
        {
            Log::add(\Joomla\CMS\Language\Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), Log::WARNING, 'jerror');
        }
        else
        {
            // Get the model.
            $model = $this->getModel();

            // Make sure the item ids are integers

            ArrayHelper::toInteger($cid);

            // Remove the items.
            if ($model->isMainImage($cid, $value))
            {
                if ($value == 1)
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_ISMAINIMAGE';
                }
                else
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_ISNOTMAINIMAGE';
                }
                $this->setMessage(\Joomla\CMS\Language\Text::plural($ntext, count($cid)));
            }
            else
            {
                $this->setMessage($model->getError());
            }
        }
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid').$this->_anchor);
    }

    public function isMainImageOnly() {
        $cid = Factory::getApplication()->input->get('cid', array(), 'array');
        $data = array('ismainimageonly' => 1, 'isnotmainimageonly' => 0);
        $task = $this->getTask();
        $value = ArrayHelper::getValue($data, $task, 0, 'int');
        if (!is_array($cid) || count($cid) < 1)
        {
            Log::add(\Joomla\CMS\Language\Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), Log::WARNING, 'jerror');
        }
        else
        {
            // Get the model.
            $model = $this->getModel();

            // Make sure the item ids are integers
            ArrayHelper::toInteger($cid);

            // Remove the items.
            if ($model->isMainImageOnly($cid, $value))
            {
                if ($value == 1)
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_ISMAINIMAGEONLY';
                }
                else
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_ISNOTMAINIMAGEONLY';
                }
                $this->setMessage(\Joomla\CMS\Language\Text::plural($ntext, count($cid)));
            }
            else
            {
                $this->setMessage($model->getError());
            }
        }
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid').$this->_anchor);
    }

    public function deleteThumbnails() {
        $this->checkToken();

        // Get items to remove from the request.
        $cid = (array) $this->input->get('cid', [], 'int');

        // Remove zero values resulting from input filter
        $cid = array_filter($cid);

        if (empty($cid)) {
            $this->getLogger()->warning(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), ['category' => 'jerror']);
        } else {
            // Get the model.
            $model = $this->getModel();

            // Remove the items.
            if ($model->deleteThumbnails($cid)) {
                $this->setMessage(Text::plural($this->text_prefix . '_N_THUMBNAILS_DELETED', \count($cid)));
            } else {
                $this->setMessage($model->getError(), 'error');
            }
        }

        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$this->input->getString('folderid').$this->_anchor);
    }

    public function resethits() {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));
        $folderid = $this->input->getInt('id');
        $model = $this->getModel('Files', '', array());

        $model->resetHits($folderid);
        $this->setMessage(Text::_('COM_EVENTGALLERY_FILES_RESET_HITS_DONE'), 'info');
        $this->setRedirect( 'index.php?option=com_eventgallery&view=files&folderid='.$folderid);
    }

}
