<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\MVC\Controller\FormController;
use \Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\FlickrAccount;

class FlickrController extends FormController
{
    public function getAlbums() {
        header('Content-Type: application/json');
        $app = Factory::getApplication();
        $db = Factory::getDbo();

        $id = $app->input->getInt('id');

        /**
         * @var FlickrAccountFactory $accountFactory
         *
         */
        $accountFactory = FlickrAccountFactory::getInstance();
        $account = $accountFactory->getAccountById($id);

        $albums = FlickrConnector::getPhotoSets($account);

        echo '{"albums":' . json_encode($albums) . '}';
        die();
    }

    public function testAuthToken() {
        header('Content-Type: application/json');
        $result =  '{"valid":false}';
        /**
         * @var Joomla\CMS\Application\AdministratorApplication $app
         */

        $app = Factory::getApplication();
        $accountid = $app->input->getInt('accountid',  null);

        if ($accountid != null) {
            /**
             * @var FlickrAccountFactory $accountFactory
             *
             */
            $accountFactory = FlickrAccountFactory::getInstance();
            $flickrAccount = $accountFactory->getAccountById($accountid);

            if ($flickrAccount != null) {
                if ($this->checkAuthToken($flickrAccount)) {
                    $result =  '{"valid":true}';
                }
            }
        }

        echo $result;
        die();
    }

    /**
     * @param $flickrAccount FlickrAccount
     */
    private function checkAuthToken($flickrAccount) {
        $oauth_nonce = '12345';
        $oauth_timestamp = time();
        $result = false;

        if (empty($flickrAccount->getAPISecret())) {
            return true;
        }

        $url = 'https://www.flickr.com/services/rest?nojsoncallback=1&format=json&oauth_nonce='.$oauth_nonce.'&oauth_consumer_key='.urlencode($flickrAccount->getAPIKey()).'&oauth_timestamp='.$oauth_timestamp.'&oauth_signature_method=HMAC-SHA1&oauth_version=1.0&oauth_token='.urlencode($flickrAccount->getAuthToken()).'&method=flickr.test.login';

        $signedUrl = \Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector::appendSignaturetoUrl('GET', $url, $flickrAccount->getAPISecret(), $flickrAccount->getAuthTokenSecret());

        $response = HttpFactory::getHttp()->get($signedUrl, [], 5);
        $code = $response->code;
        $body = $response->body;
        if ($code == 200) {
            $data = json_decode($response->body);
            if ($data->stat == 'ok') {
                $result = true;
            }


        }
        return $result;
    }

}
