<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;
defined('_JEXEC') or die;

class FlickraccountController extends FormController
{
    public function flickrcallback() {

        $app = Factory::getApplication();
        $id = $app->input->getInt('accountid', null);
        $oauth_verifier = $app->input->getRaw('oauth_verifier', null);
        $oauth_token = $app->input->getRaw('oauth_token', null);

        if ($oauth_token==null || $oauth_verifier == null || $id == null) {
            $app->close('invalid request');
        }

        /**
         * @var FlickrAccountFactory $factory
         */
        $factory = FlickrAccountFactory::getInstance();
        $account = $factory->getAccountById($id);

        $oauth_nonce = '12345';
        $oauth_timestamp = time();


        $session = Factory::getSession();
        $oauth_token_secret = $session->get('flickr_oauth_token_secret');

        $url = 'https://www.flickr.com/services/oauth/access_token?oauth_nonce='.$oauth_nonce.'&oauth_timestamp='.$oauth_timestamp.'&oauth_verifier='.$oauth_verifier.'&oauth_consumer_key='.$account->getAPIKey().'&oauth_signature_method=HMAC-SHA1&oauth_version=1.0&oauth_token='.$oauth_token;
        $signedUrl = \Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector::appendSignaturetoUrl('GET', $url, $account->getAPISecret(), $oauth_token_secret);

        $result = HttpFactory::getHttp()->get($signedUrl, [], 5);

        parse_str($result->body, $tokenData);

        $model = $this->getModel();
        $accountPageUrl =  Route::_('index.php?option=com_eventgallery&view=flickraccount&id='.$account->getId(), false);

        if (isset($tokenData['oauth_problem'])) {
            echo "Request to Flickr failed. Message body: ";
            echo $result->body;
            echo "<a href=\"$accountPageUrl\">Go back to the Flickr account</a>";
        } else {
            $oauth_token = $tokenData['oauth_token'];
            $oauth_token_secret = $tokenData['oauth_token_secret'];
            $user_id = $tokenData['user_nsid'];

            $data = ['id' => $account->getId(),
                'user_id' => $user_id,
                'auth_token' => $oauth_token,
                'auth_token_secret' => $oauth_token_secret];
            $model->save($data);
            $this->setRedirect($accountPageUrl);
        }

    }
}
