<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Session\Session;
use Svenbluege\Component\Eventgallery\Administrator\Model\GdprModel;
use Svenbluege\Component\Eventgallery\Site\Library\Address;
use Svenbluege\Component\Eventgallery\Site\Library\Cart;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\AbstractMethod;

defined('_JEXEC') or die;

class GdprController extends FormController
{

    protected $default_view = 'gdpr';

    public function export()
    {
        // Check for request forgeries.
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));


        $app = \Joomla\CMS\Factory::getApplication();

        $email = $app->input->getString('email');
        if (strlen($email)<5) {
            $app->enqueueMessage(Text::_('COM_EVENTGALLERY_GDPR_EXPORT_INVALID_EMAIL'));
            return;
        }
        $filename = "user-data-export.json";

        /**
         * @var GdprModel $model
         */
        $model = $this->getModel();

        $carts = $model->getCarts($email);
        $orders = $model->getOrders($email);
        $users = $model->getUsers($email);

        $data = [];

        $data[Text::_('COM_EVENTGALLERY_GDPR_CARTS')] = array_map(array($this,'renderCart'), $carts);
        $data[Text::_('COM_EVENTGALLERY_GDPR_ORDERS')] = array_map(array($this,'renderOrder'), $orders);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS')] = array_map(array($this,'renderUser'), $users);

        echo json_encode($data, JSON_PRETTY_PRINT);

        header('Content-type: text/plain');
        header('Content-disposition: attachment; filename="' . $filename . '"');

        $app->close();

    }

    /**
     * @param $cart Cart
     * @return array
     */
    private function renderCart($cart) {
        $data = [];
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_ID')] = $cart->getId();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_FIRSTNAME')] = $cart->getFirstname();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_LASTNAME')] = $cart->getLastname();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_PHONE')] = $cart->getPhone();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_MESSAGE')] = $cart->getMessage();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_EMAIL')] = $cart->getEMail();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_BILLING')] = $this->renderAddress($cart->getBillingAddress());
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_SHIPPING')] = $this->renderAddress($cart->getShippingAddress());
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_SHIPPINGMETHOD')] = $this->renderShippingMethod($cart->getShippingMethodServiceLineItem());
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_LINEITEMCONTAINER_PAYMENTMETHOD')] = $this->renderPaymentMethod($cart->getPaymentMethodServiceLineItem());

        return $data;
    }

    private function renderOrder($order) {
        return $this->renderCart($order);
    }

    /**
     * @param $user \Joomla\CMS\User\User
     * @return array
     */
    private function renderUser($user) {

        $data = [];
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_ID')] = $user->id;
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EMAIL')] = $user->email;
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_SENDEMAIL')] = $user->sendEmail;
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_NAME')] = $user->name;
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_USERNAME')] = $user->username;

        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_FIRSTNAME')] = $user->getParam(Address::USER_ADDRESS_BASIC_FIRSTNAME_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_LASTNAME')] = $user->getParam(Address::USER_ADDRESS_BASIC_LASTNAME_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_EMAIL')] = $user->getParam(Address::USER_ADDRESS_BASIC_EMAIL_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_MESSAGE')] = $user->getParam(Address::USER_ADDRESS_BASIC_MESSAGE_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_PHONE')] = $user->getParam(Address::USER_ADDRESS_BASIC_PHONE_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_BILLING')] = $user->getParam(Address::USER_ADDRESS_BILLING_KEY);
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_USER_EG_SHIPPING')] = $user->getParam(Address::USER_ADDRESS_SHIPPING_KEY);

        return $data;
    }

    private function renderShippingMethod($shippingMethod) {
        return $this->renderMethod($shippingMethod);
    }

    private function renderPaymentMethod($paymentMethod) {
        return $this->renderMethod($paymentMethod);
    }

    /**
     * @param $method AbstractMethod
     */
    private function renderMethod($method) {
        $data = [];

        if ($method == null) {
            return $data;
        }
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_METHOD_NAME')] = $method->getName();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_METHOD_DISPLAYNAME')] = $method->getDisplayName();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_METHOD_DATA')] = $method->getData();
        return $data;
    }


    /**
     * @param $address Address
     */
    private function renderAddress($address) {
        $data = [];

        if (null == $address) {
            return $data;
        }

        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_FIRSTNAME')] = $address->getFirstName();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_LASTNAME')] = $address->getLastName();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_ADDRESS1')] = $address->getAddress1();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_ADDRESS2')] = $address->getAddress2();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_ADDRESS3')] = $address->getAddress3();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_CITY')] = $address->getCity();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_ZIP')] = $address->getZip();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_COUNTRY')] = $address->getCountry();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_STATE')] = $address->getState();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_COMPANY')] = $address->getCompanyName();
        $data[Text::_('COM_EVENTGALLERY_GDPR_USERS_ADDRESS_TAX_ID')] = $address->getTaxId();

        return $data;
    }


}
