<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
defined('_JEXEC') or die;

class GooglephotosController extends FormController
{
    public function getAlbums() {
        header('Content-Type: application/json');
        $app = Factory::getApplication();
        $db = Factory::getDbo();

        $id = $app->input->getInt('id');

        /**
         * @var GooglePhotosAccountFactory $accountFactory
         *
         */
        $accountFactory = GooglePhotosAccountFactory::getInstance();
        $account = $accountFactory->getAccountById($id);

        $albums = \Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector::getAlbums(COM_EVENTGALLERY_GOOGLE_PHOTOS_ALBUMS_CACHE_LIFETIME, $account->getClientId(), $account->getSecret(), $account->getRefreshToken(), $db);

        echo '{"albums":' . json_encode($albums) . '}';
        die();
    }

    public function testRefreshToken() {
        header('Content-Type: application/json');
        /**
         * @var Joomla\CMS\Application\AdministratorApplication $app
         */

        $app = Factory::getApplication();
        $accountid = $app->input->getInt('accountid',  null);
        $result = '{"valid":false}';

        if ($accountid != null) {
            /**
             * @var GooglePhotosAccountFactory $gpaFactory
             */
            $gpaFactory = GooglePhotosAccountFactory::getInstance();
            $account = $gpaFactory->getAccountById($accountid);
            if ($account != null) {
                $response = \Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector::requestAccessToken($account->getClientId(), $account->getSecret(), $account->getRefreshToken());
                if (isset($response->access_token)) {
                    $result =  '{"valid":true}';
                }
            }
        }

        echo $result;
        die();
    }

}
