<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Router\Route;
use Joomla\Database\DatabaseInterface;
use Svenbluege\Component\Eventgallery\Site\Library\Connector\GooglePhotosConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die;

class GooglephotosaccountController extends FormController
{
    public function googlecallback() {

        $app = Factory::getApplication();
        $id = $app->input->getInt('state', null);
        $code = $app->input->getRaw('code', null);

        if ($code == null || $id == null) {
            $app->close('invalid request');
        }

        /**
         * @var GooglePhotosAccountFactory $factory
         */
        $factory = GooglePhotosAccountFactory::getInstance();
        $account = $factory->getAccountById($id);

        $callbackUrl = Route::_('index.php?option=com_eventgallery&task=googlephotosaccount.googlecallback', false, 1, true);
        $data = [
            'code' => $code,
            'client_id' => $account->getClientId(),
            'client_secret' => $account->getSecret(),
            'grant_type' => 'authorization_code',
            'redirect_uri' => $callbackUrl,
        ];

        $response = \Joomla\CMS\Http\HttpFactory::getHttp()->post('https://oauth2.googleapis.com/token', $data, ['Content-Type' => 'application/x-www-form-urlencoded'], 3);
        if ($response->code == 200) {
            $response_body = json_decode($response->body);
            echo '
            <script>
                window.opener.document.getElementsByClassName("google-photos-api-oauth-input")[0].value = \''. $response_body->refresh_token .'\';
                window.close();
            </script>
            ';
        } else {
            echo "An error has occured: " . $response->body;
        }

        $app->close();

    }

    public function getpickersession() {
        $app = Factory::getApplication();
        $id = $app->input->getInt('id', null);
        $doNewSession = $app->input->getBool('newsession', false);

        /**
         * @var GooglePhotosAccountFactory $factory
         */
        $factory = GooglePhotosAccountFactory::getInstance();
        $account = $factory->getAccountById($id);
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        $pickerSession = GooglePhotosConnector::getPickerSession($db, $account, $doNewSession);
        if ($pickerSession) {
            echo json_encode($pickerSession, JSON_PRETTY_PRINT);
        } else {
            http_response_code("500");
            echo '{"error": "'.Text::_('COM_EVENTGALLERY_EVENT_UPLOAD_GOOGLE_PICKER_SESSION_ERROR').'"}';
        }

        $app->close();
    }

    public function fetchimages() {
        $app = Factory::getApplication();
        $id = $app->input->getInt('id', null);
        $pageToken = $app->input->getString('pageToken', null);

        /**
        * @var GooglePhotosAccountFactory $factory
        */
        $factory = GooglePhotosAccountFactory::getInstance();
        $account = $factory->getAccountById($id);
        $db = Factory::getContainer()->get(DatabaseInterface::class);

        echo json_encode(GooglePhotosConnector::fetchImages($db, $account, $pageToken));

        $app->close();

    }

    public function fetchimage() {
        $app = Factory::getApplication();
        $id = $app->input->getInt('id', null);
        $baseUrl = $app->input->getString('baseUrl', null);


        /**
         * @var GooglePhotosAccountFactory $factory
         */
        $factory = GooglePhotosAccountFactory::getInstance();
        $account = $factory->getAccountById($id);
        $db = Factory::getContainer()->get(DatabaseInterface::class);


        $imageResponse = GooglePhotosConnector::fetchImage($db, $account, $baseUrl);
        header("Content-Type: {$imageResponse->contentType}");
        header("Content-Disposition: {$imageResponse->contentDisposition}");
        $imageResponse->imageData->rewind();
        echo $imageResponse->imageData->__toString();

        $app->close();
    }

    public function getaccounts() {
        $app = Factory::getApplication();
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        /**
         * @var GooglePhotosAccountFactory $factory
         */
        $factory = GooglePhotosAccountFactory::getInstance();
        $accounts = $factory->getUsableAccounts();

        $accounts = array_filter($accounts, function(/** @var GooglePhotosAccount $account */ $account) {
            return $account->isPublished();
        });

        $response = [];
        foreach ($accounts as $account) {
            $response[] = [
                'id' => $account->getId(),
                'name' => $account->getName(),
                'ordering' => $account->getOrdering(),
            ];
        }

        echo json_encode($response);
        $app->close();
    }
}
