<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\AdminController;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
defined('_JEXEC') or die('Restricted access');

class JsonController extends AdminController
{
    public function getFiles() {
        $app = Factory::getApplication();
        $foldername = $app->input->getString('folder');
        if ($foldername == null || $foldername == '') {
            return false;
        }

        /**
        * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $file
        */
         $files = $this->getModel()->getFiles($foldername);

        $result = [];
        foreach($files as $file) {
            $result[] = [
                "folder" => $file->getFolderName(),
                "file" => $file->getFileName(),
                "displayname" => $file->getFileTitle(),
                "description" => $file->getFileCaption(),
                "published" => $file->isPublished(),
                "thumbnail" => $file->getThumbUrl(250)
            ];
        }

        echo json_encode($result);

        return true;
    }

    public function getEvents() {

        /**
        * @var Folder $folder
         */
        $folders = $this->getModel()->getFolders();

        $result = [];
        foreach($folders as $folder) {
            $result[] = [
                "folder" => $folder->getFolderName(),
                "displayname" => $folder->getDisplayName(),
                "description" => $folder->getText(),
                "published" => $folder->isPublished(),
                "passwordprotected" => !empty($folder->getPassword()),
                "usergroups" => $folder->getUserGroupIds(),
                "foldertype" => $folder->getFolderType()->getDisplayName()
            ];
        }

        echo json_encode($result);

        return true;
	}

}
