<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\Utilities\ArrayHelper;
defined('_JEXEC') or die('Restricted access');

class MethodsController extends AdminController
{
    protected $model_name ='';
    public function __construct($config = array(), \Joomla\CMS\MVC\Factory\MVCFactoryInterface $factory = null, ?\Joomla\CMS\Application\CMSApplication $app = null, ?\Joomla\Input\Input $input = null)
    {
        parent::__construct($config, $factory, $app, $input);
        $this->registerTask('default', 'setDefault');
        $this->registerTask('undefault', 'setDefault');
    }

    /**
     * Proxy for getModel.
     * @param string $name
     * @param string $prefix
     * @param array $config
     * @return object
     */
    public function getModel($name = '', $prefix ='', $config = array('ignore_request' => true))
    {
        return parent::getModel($this->model_name, $prefix, $config);
    }

    public function setDefault() {

        $cid = Factory::getApplication()->input->get('cid', array(), 'array');
        $data = array('undefault' => 0, 'default' => 1);
        $task = $this->getTask();
        $value = ArrayHelper::getValue($data, $task, 0, 'int');
        if (!is_array($cid) || count($cid) < 1)
        {
            JLog::add(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
        }
        else
        {
            // Get the model.
            $model = $this->getModel();

            // Make sure the item ids are integers
            ArrayHelper::toInteger($cid);

            // Remove the items.
            if ($model->setDefault($cid, $value))
            {
                if ($value == 1)
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_DEFAULT';
                }
                else
                {
                    $ntext = $this->text_prefix . '_N_ITEMS_UNDEFAULT';
                }
                $this->setMessage(Text::plural($ntext, count($cid)));
            }
            else
            {
                $this->setMessage($model->getError());
            }
        }
        $this->setRedirect( 'index.php?option=com_eventgallery&view='.$this->default_view);

    }
}
