<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Log\Log;
use Joomla\CMS\MVC\Controller\AdminController;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

defined('_JEXEC') or die('Restricted access');



class OrdersController extends AdminController
{

    protected $view_list = "orders";

    public function delete()
    {
        // Check for request forgeries
        Session::checkToken() or die(Text::_('JINVALID_TOKEN'));

        // Get items to remove from the request.
        $cid = Factory::getApplication()->input->get('cid', array(), 'array');

        $model = null;

        if (!is_array($cid) || count($cid) < 1)
        {
            Log::add(Text::_($this->text_prefix . '_NO_ITEM_SELECTED'), JLog::WARNING, 'jerror');
        }
        else
        {
            // Get the model.
            $model = $this->getModel('order');

            // Remove the items.
            if ($model->delete($cid))
            {
                $this->setMessage(Text::plural($this->text_prefix . '_N_ITEMS_DELETED', count($cid)));
            }
        }
        // Invoke the postDelete method to allow for the child class to access the model.
        if (method_exists($this, 'postDeleteHook')) {
            $this->postDeleteHook($model, $cid);
        }

        $this->setRedirect(Route::_('index.php?option=' . $this->option . '&view=' . $this->view_list, false));
    }

}
