<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Uri\Uri;
use Svenbluege\Component\Eventgallery\Site\Library\Common\ImageProcessor;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Watermark;

defined('_JEXEC') or die;

/**
 * TODO: Delete this and implement only in the frontend. Leftover from the J4 migration
 */
class ResizeimageController extends BaseController {
    public function display($cachable = false, $urlparams = array()) {
        $file = $this->input->getString('file');
        $folder = $this->input->getString('folder');

        $width = $this->input->getInt('width', -1);

        /**
         * @var FileFactory $fileFactory
         */
        $fileFactory = FileFactory::getInstance();
        $fileObj = $fileFactory->getFile($folder, $file);
        $folderObj = $fileObj->getFolder();

        $user = Factory::getUser();
        if (!$user->authorise('core.manage', 'com_eventgallery')){
            if (!$fileObj->isMainImage()) {
                if (!$folderObj->isVisible() || !$folderObj->isAccessible()) {
                    $url = Uri::root() . COM_EVENTGALLERY_IMAGE_NO_ACCESS;
                    header("HTTP/1.1 302 Found");
                    header("Location: $url");
                    header('Content-Type: text/plain');
                    header('Connection: close');
                    flush();
                    die();
                }
            }
        }


        $this->renderThumbnail($folder, $file, $width);
        $this->endExecution();
    }

    public function endExecution() {
        die();
    }


    /**
     * This method calculates the image and delivers it to the client.
     *
     * @param $folder
     * @param $file
     * @param $width
     * @param $doFindMatingSize defined if we try to find a size in the list of possible images sized
     * @param $doCache
     * @param $doWatermarking
     * @param $watermark Watermark
     * @param $doSharping
     *
     */
    public function renderThumbnail($folder, $file, $width = -1, $doFindMatingSize = true, $doCache = true, $doWatermarking = true, $watermark = null, $doSharping = true) {

        ImageProcessor::renderThumbnail($folder, $file, $width, $doFindMatingSize, $doCache, $doWatermarking, $watermark, $doSharping);
    }
}
