<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Controller\FormController;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\LocalFolder;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\S3Folder;

defined('_JEXEC') or die;

class RestController extends FormController
{

    /**
     * returns all folders as JSON object
     *
     * @param bool $cachable
     * @param array $urlparams
     */
    public function folders($cachable = false, $urlparams = array())
    {
        $document = Factory::getDocument();
        $document->setMimeEncoding('application/json');

        $data = [];

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        $folders = $folderFactory->getAllFolders();
        foreach($folders as $folder) {
            /**
             * @var Folder $folder
             */

            $data []= [
                "id"=>$folder->getId(),
                "folder"=>$folder->getFolderName(),
                "name"=>$folder->getDisplayName(),
                "published" => $folder->isPublished()];
        }

        echo json_encode($data, JSON_PRETTY_PRINT);
    }

    /**
     * returns all folders as JSON object
     *
     * @param bool $cachable
     * @param array $urlparams
     */
    public function files($cachable = false, $urlparams = array())
    {

        $app = Factory::getApplication();
        $foldername = $app->input->getString('folder');
        if ($foldername == null) {
            return;
        }

        $document = Factory::getDocument();
        $document->setMimeEncoding('application/json');

        $data = [];

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        $folder = $folderFactory->getFolder($foldername);
        if ($folder == null) {
            return;
        }

        foreach($folder->getFiles() as $file) {
            /**
             * @var File $file
             */
            $data []= [
                "id"=>$file->getId(),
                "folder"=>$file->getFolderName(),
                "file"=>$file->getFileName(),
                "thumb"=>$file->getThumbUrl(250),
                "published" => $folder->isPublished(),
            ];
        }

        echo json_encode($data, JSON_PRETTY_PRINT);
    }

    public function numberofmissingthumbnails() {
        $document = Factory::getDocument();
        $document->setMimeEncoding('application/json');
        $config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();

        $data = [];
        $count = 0;

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();

        $folders = $folderFactory->getAllFolders();
        foreach ($folders as $folder) {
            if (($config->getImage()->doUsePrecalculatedThumbnailsForLocalFiles() && $folder->getFolderType()->getId() == LocalFolder::ID) || $folder->getFolderType()->getId() == S3Folder::ID) {
                /**
                 * @var Folder\LocalFolder $folder
                 */
                $files = $folder->getFilesToSync();
                if ($files) {
                    $count += count($files);
                }
            }
        }

        $data['numberOfMissingThumbnails'] = $count;

        echo json_encode($data, JSON_PRETTY_PRINT);
    }
}
