<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Controller;
use Joomla\CMS\MVC\Controller\FormController;
use Joomla\CMS\Session\Session;
use Svenbluege\Component\Eventgallery\Administrator\Model\SyncModel;
use Svenbluege\Component\Eventgallery\Site\Library\File\File;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die;


class ThumbnailgeneratorController extends FormController
{


    /**
     * The root folder for the physical images
     *
     * @var string
     */

    protected $default_view = 'thumbnailgenerator';

    /**
     * just cancels this view
     * @param null $key
     * @return bool|void
     */
	public function cancel($key = NULL) {
		$this->setRedirect( 'index.php?option=com_eventgallery&view=events');
	}

    /**
     * initializes the syncronization.
     *
     * @param bool $cachable
     * @param array $urlparams
     */
    public function init($cachable = false, $urlparams = array())
    {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));

        /**
         * @var SyncModel $model
         */
        $model = $this->getModel();


        /**
         * @var Folder[] $existingfolders
         */
        $existingfolders = $model->getFolders();

        $result = [];

        foreach($existingfolders as $folder) {
            array_push($result, ['foldername' => $folder->getFolderName(), 'error'=>null, 'isNew'=>false, 'foldertype'=>$folder->getFolderType()->getId()]);
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function processfolder(/** @noinspection PhpUnusedParameterInspection */$cachable = false, $urlparams = array()) {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));
        $folder = $this->input->getString('folder','');
        $refreshETagsStr = $this->input->getString('refreshetags', "true");
        $refreshETags = !strcasecmp($refreshETagsStr, "false") == 0;
        /**
         * @var File[] $files
         */
        $files =  $this->getModel()->getFilesToSync($folder, $refreshETags);
        $filenames = [];
        forEach($files as  $file) {
            array_push($filenames, $file->getFileName());
        }

        $result = Array();
        $result['folder'] = htmlspecialchars($folder);
        $result['status'] = 'sync';
        $result['files'] = $filenames;

        echo json_encode($result, JSON_PRETTY_PRINT);
    }

    public function processfile() {
        Session::checkToken() or jexit(Text::_('JINVALID_TOKEN'));
        $foldernames = $this->input->getString('folder','');
        $filenames = $this->input->getString('file','');

        if (!is_array($foldernames) || !is_array($filenames)) {
            echo '[]';
            return;
        }
        $result = [];
        for($i=0; $i<count($foldernames); $i++) {
            array_push($result, [
                'foldername'=>$foldernames[$i],
                'filename'=>$filenames[$i],
                'sizes' => $this->getModel()->createThumbnails($foldernames[$i], $filenames[$i])
            ]);
        }

        echo json_encode($result, JSON_PRETTY_PRINT);
    }


}
