<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Extension;

defined('_JEXEC') or die;

use JLoader;
use Joomla\CMS\Categories\CategoryServiceInterface;
use Joomla\CMS\Categories\CategoryServiceTrait;
use Joomla\CMS\Component\Router\RouterServiceInterface;
use Joomla\CMS\Component\Router\RouterServiceTrait;
use Joomla\CMS\Extension\BootableExtensionInterface;
use Joomla\CMS\Extension\MVCComponent;
use Joomla\CMS\Table\Table;
use Psr\Container\ContainerInterface;


/**
 * Component class for com_eventgallery
 *
 * @since  4.0.0
 */
class EventgalleryComponent extends MVCComponent implements BootableExtensionInterface, RouterServiceInterface, CategoryServiceInterface
{
    use RouterServiceTrait;
    use CategoryServiceTrait;


    public function boot(ContainerInterface $container)
    {
        $this->loadConfiguration();
    }

    private function loadConfiguration() {
        require_once JPATH_ADMINISTRATOR.'/components/com_eventgallery/version.php';
        require_once JPATH_ROOT.'/components/com_eventgallery/config.php';
        require_once JPATH_ROOT.'/components/com_eventgallery/vendor/autoload.php';
    }

    /**
     * Returns the table for the count items functions for the given section.
     *
     * @param   string  $section  The section
     *
     * @return  string|null
     *
     * @since   4.0.0
     */
    protected function getTableNameForSection(string $section = null)
    {
        return 'eventgallery_folder';
    }

    /**
     * Returns the state column for the count items functions for the given section.
     *
     * @param   string  $section  The section
     *
     * @return  string|null
     *
     * @since   4.0.0
     */
    protected function getStateColumnForSection(string $section = null)
    {
        return 'published';
    }
}
