<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\EmailTemplateManager;
defined('_JEXEC') or die('Restricted access');

class EmailtemplatekeysField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'emailtemplatekeys';


    public function getInput()
    {
        /**
         * @var EmailTemplateManager $emailtemplateMgr
         */
        $emailtemplateMgr = EmailTemplateManager::getInstance();

        $keys = $emailtemplateMgr->getEmailtemplateKeys();

        $return  = '<select class="form-select" name='.$this->name.' id='.$this->id.'>';

        foreach($keys as $key=>$displayname) {
            $selected = $key == $this->value? 'selected="selected"':'';
            $return .= "<option $selected value=\"".$key."\">".Text::_($displayname).'</option>';
        }

        $return .= "</select>";
        return $return;

    }
}
