<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;
use Svenbluege\Component\Eventgallery\Site\Library\Connector\FlickrConnector;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;

class FlickrauthtokenField extends FormField
{
    //The field class must know its own type through the variable $type.
    protected $type = 'flickrauthtoken';

    public function getInput()
    {

        Backendmedialoader::load();

        $id = $this->form->getValue("id");

        /**
         * @var FlickrAccountFactory $accountFactory
         *
         */
        $accountFactory = FlickrAccountFactory::getInstance();
        $flickrAccount = $accountFactory->getAccountById($id);
        $auth_token_secret = "";
        $return = [];

        if ($flickrAccount != null) {
            $auth_token_secret = $flickrAccount->getAuthTokenSecret();
        }

        $redirectUrl = $this->getRedirectUrl($flickrAccount);


        if (!empty($redirectUrl)) {
            $return[] = '<div class="input-group">';
            $return[] = '<a href="'.$redirectUrl.'" class="btn active btn-success">' . Text::_('COM_EVENTGALLERY_FLICKR_AUTHTOKEN_BUTTON_LABEL') . '</a>';
            $return[] = '<input class="form-control" name="' . $this->name . '" value="' . $this->value . '" id="' . $this->id . '"/>';
            $return[] = '<input type="password" class="form-control" name="' . str_replace('auth_token', 'auth_token_secret', $this->name) . '" value="' . $auth_token_secret . '" id="' . str_replace('auth_token', 'auth_token_secret', $this->id) . '"/><br>';
            $return[] = '</div>';
        } else {
            $return[] = Text::_('COM_EVENTGALLERY_FLICKRACCOUNT_AUTHTOKEN_CLIENT_CREDENTIALS_MISSING_LABEL') ;
        }

        return implode('', $return);
    }

    private function getRedirectUrl($flickrAccount) {

        if (empty($flickrAccount)) return;

        $callbackUrl = Route::_('index.php?option=com_eventgallery&task=flickraccount.flickrcallback&accountid='. $flickrAccount->getId() , false, 1, true);
        $oauth_nonce = '12345';
        $oauth_timestamp = time();

        $requestTokenUrl = "https://www.flickr.com/services/oauth/request_token?oauth_nonce=$oauth_nonce&oauth_timestamp=$oauth_timestamp&oauth_consumer_key={$flickrAccount->getAPIKey()}&oauth_signature_method=HMAC-SHA1&oauth_version=1.0&oauth_callback=".urlencode($callbackUrl);
        $signedRequestTokenUrl = FlickrConnector::appendSignaturetoUrl('GET', $requestTokenUrl, $flickrAccount->getAPISecret(), null);

        $headers = ['User-Agent' => 'User-Agent: PHP_Flickr_EG/1.0'];

        $result = HttpFactory::getHttp()->get($signedRequestTokenUrl, $headers, 5);

        parse_str($result->body, $tokenData);

        if (!isset($tokenData['oauth_token'])) {
            //echo "<pre>".$result->body."</pre>";
            return "";
        }
        $oauth_token = $tokenData['oauth_token'];
        $oauth_token_secret = $tokenData['oauth_token_secret'];

        $session = Factory::getSession();
        $session->set('flickr_oauth_token_secret', $oauth_token_secret);

        return "https://www.flickr.com/services/oauth/authorize?oauth_token=$oauth_token";

    }


}
