<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\FlickrAccount;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die('Restricted access');

class FoldertypeField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'foldertype';

    public function getInput()
    {
        Backendmedialoader::load();

        /**
         * @var FolderTypeFactory $foldertypeFactory
         */
        $foldertypeFactory = FolderTypeFactory::getInstance();

        $foldertypes = $foldertypeFactory->getFolderTypes(true);

        $value = $this->form->getValue('foldertypeid');

        if ($value === null  && $foldertypeFactory->getDefaultFolderType(false) != null) {
            $value = $foldertypeFactory->getDefaultFolderType(false)->getId();
        }

        $return = Array();

        $onchange  = "let in1=document.getElementsByClassName('foldertype-input');";
        $onchange .= "for(let i=0;i<in1.length;i++) in1[i].style.display='none';";
        $onchange .= "let in2=document.getElementsByClassName('foldertype-' + this.options[this.selectedIndex].value);";
        $onchange .= "for(let i=0;i<in2.length;i++) in2[i].style.display='block';";

        $return[]  = '<select class="form-select custom-select" onchange="'. $onchange .'" name="jform[foldertypeid]" id="jform_foldertypeid">';
        foreach($foldertypes as $foldertype) {
            /**
             * @var FolderType $foldertype
             */

            $value==$foldertype->getId()?$selected='selected="selected"':$selected ='';

            $return[] = '<option '.$selected.' value="'.$foldertype->getId().'">'.$foldertype->getDisplayName().'</option>';
        }
        $return[] = "</select>";

        $return[] = $this->getLocalInput();

        $return[] = $this->getFlickrInput();

        $return[] = $this->getS3Input();

        $return[] = $this->getGooglePhotosInput();

        $return[] = $this->getGooglePhotosSharedPageInput();

        $return[] = $this->getFolderInputField();

        $currentFolderType = 0;
        if (isset($value) ) {
            $currentFolderType = $value;
        }

        $return[] = "<script>";
        $return[] = "document.addEventListener('DOMContentLoaded', (event) => {";
        $return[] = "  let in1 = document.getElementsByClassName('foldertype-input');";
        $return[] = "  for(let i=0;i<in1.length;i++) in1[i].style.display = 'none';";
        $return[] = "  let in2 = document.getElementsByClassName('foldertype-$currentFolderType');";
        $return[] = "  for(let i=0;i<in2.length;i++) in2[i].style.display = 'block';";
        $return[] = "});";

        $return[] = "</script>";

        $return[] = "<hr>";

        return implode('', $return);
    }

    protected function getLocalInput() {
        $result = Array();
        $value = $this->form->getValue("folder")?:'';
        $result[] = '<div class="foldertype-0 foldertype-input">';
        $result[] = '<br>'. Text::_('COM_EVENTGALLERY_EVENTS_SOURCE_LOCAL_FOLDER_DESC') .'<br>';
        $result[] = '<input class="form-control" onchange="document.getElementById(\'jform_folder\').value=this.value" type="text" id="foldertype-0-foldername" value="'.htmlspecialchars($value, ENT_COMPAT, 'UTF-8').'" />';
        $result[] = $this->renderHelText('COM_EVENTGALLERY_EVENTS_SOURCE_LOCAL_DESC');
        $result[] = '</div>';

        return implode('', $result);
    }

    protected function getFlickrInput() {
        $result = Array();
        $value = $this->form->getValue("folder")?:'';
        $accountid = $this->form->getValue("flickraccountid");
        $album = $value;
        $title = $this->form->getValue("flickrtitle");

        /**
         * @var FlickrAccountFactory $accountFactory
         *
         */
        $accountFactory = FlickrAccountFactory::getInstance();
        $accounts = $accountFactory->getUsableAccounts();

        $onchange = "document.getElementById('jform_folder').value = document.getElementById('foldertype-2-photosetid').value;";
        $onchange.= "document.getElementById('jform_flickraccountid').value=document.getElementById('foldertype_2_account').options[document.getElementById('foldertype_2_account').selectedIndex].value;";
        $onchange.= "document.getElementById('jform_flickrtitle').value=document.getElementById('foldertype-2-title').value;";

        $result[] = '<div class="foldertype-2 foldertype-input">';
        if (count($accounts) > 0) {
            $result[] = "<br><label for='foldertype_2_account'>".Text::_('COM_EVENTGALLERY_FIELD_FOLDERTYPE_FLICKR_ACCOUNT')."</label><br>";
            $result[] = '<select class="form-select custom-select" id="foldertype_2_account" name="foldertype_2_account" onchange="' . $onchange . '">';
            $result[] = '<option value="">---</option>';
            foreach($accounts as $account) {
                /**
                 * @var FlickrAccount $account
                 */

                $result[] = '<option '. ($accountid == $account->getId()?'selected':'') .' value="'.$account->getId().'">'.$account->getName().'</option>';

            }
            $result[] = "</select>";
        }


        $result[] = '<br>'. Text::_('COM_EVENTGALLERY_EVENTS_SOURCE_FLICKR_PHOTOSET_DESC') .'<br>';
        $result[] = '<input class="form-control" onchange="document.getElementById(\'jform_folder\').value=this.value" type="text" id="foldertype-2-photosetid" value="'.htmlspecialchars($value, ENT_COMPAT, 'UTF-8').'" />';
        $result[] = $this->renderHelText('COM_EVENTGALLERY_EVENTS_SOURCE_FLICKR_DESC');
        $result[] = "<br>";
        $result[] = Text::_('COM_EVENTGALLERY_FIELD_FOLDERTYPE_FLICKR_ALBUMNAME')."<br>";
        $result[] = '<input class="form-control" disabled="true" onchange="' . $onchange . '"type="text" id="foldertype-2-title" value="' . $title . '" />';
        $result[] = "<br>";

        $result[] = \Joomla\CMS\HTML\HTMLHelper::_(
            'bootstrap.renderModal',
            'flickr-album-selector-modal',
            array(
                'title' => Text::_('COM_EVENTGALLERY_EVENT_FLICKR_ABLUM_SELECTOR'),
                'url' =>  Route::_('index.php?option=com_eventgallery&view=flickr&layout=albumselector&tmpl=component'),
                'bodyHeight' => '80',
                'modalWidth' => '80',
            )
        );

        $result[] = '<span data-bs-toggle="modal" data-bs-target="#flickr-album-selector-modal" data-toggle="modal" data-target="#flickr-album-selector-modal" class="btn btn-primary">' . Text::_('COM_EVENTGALLERY_EVENT_FLICKR_ABLUM_SELECTOR') . '</span>';
        $result[] = '<div id="foldertype-2-albumselectoriframe" ></div>';
        $result[] = '</div>';

        $flickraccountid = $this->form->getValue('flickraccountid');
        $flickrtitle = $this->form->getValue('flickrtitle');
        $result[] = '<input type="hidden" name="jform[flickraccountid]" id="jform_flickraccountid" value="'.$flickraccountid.'">';
        $result[] = '<input type="hidden" name="jform[flickrtitle]" id="jform_flickrtitle" value="'.$flickrtitle.'">';
        return implode('', $result);
    }

    protected function getS3Input() {
        $result = Array();
        $value = $this->form->getValue("folder")?:'';
        $result[] = '<div class="foldertype-3 foldertype-input">';
        $result[] = '<br>'. Text::_('COM_EVENTGALLERY_EVENTS_SOURCE_S3_FOLDER_DESC') .'<br>';
        $result[] = '<input class="form-control" onchange="document.getElementById(\'jform_folder\').value=this.value" type="text" id="foldertype-3-foldername" value="'.htmlspecialchars($value, ENT_COMPAT, 'UTF-8').'" />';
        $result[] = $this->renderHelText('COM_EVENTGALLERY_EVENTS_SOURCE_S3_DESC');
        $result[] = '</div>';

        return implode('', $result);
    }

    protected function getGooglePhotosInput() {

        $result = Array();
        $value = $this->form->getValue("folder")?:'';
        $accountid = $this->form->getValue("googlephotosaccountid");
        $album = $value;
        $title = $this->form->getValue("googlephotostitle");

        /**
         * @var GooglePhotosAccountFactory $accountFactory
         *
         */
        $accountFactory = GooglePhotosAccountFactory::getInstance();
        $accounts = $accountFactory->getUsableAccounts();

        $onchange = "document.getElementById('jform_folder').value = document.getElementById('foldertype-4-album').value;";
        $onchange.= "document.getElementById('jform_googlephotosaccountid').value=document.getElementById('foldertype_4_account').options[document.getElementById('foldertype_4_account').selectedIndex].value;";
        $onchange.= "document.getElementById('jform_googlephotostitle').value=document.getElementById('foldertype-4-title').value;";

        $result[] = '<div class="foldertype-4 foldertype-input">';

        if (count($accounts) == 0) {
            $result[] = '<br><br><strong>' . Text::_('COM_EVENTGALLERY_OPTIONS_COMMON_GOOGLE_PHOTOS_API_WARNING') . '</strong>';
            $result[] = '<br><br><a href="'.  Route::_('index.php?option=com_eventgallery&view=googlephotosaccounts') .'">'.Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNTS').'</a>';
        } else {

            $result[] = "<br><label for='foldertype_4_account'>".Text::_('COM_EVENTGALLERY_FIELD_FOLDERTYPE_GOOGLEPHOTOS_ACCOUNT')."</label><br>";
            $result[] = '<select class="form-select custom-select" id="foldertype_4_account" name="foldertype_4_account" onchange="' . $onchange . '">';
            foreach($accounts as $account) {
                /**
                 * @var GooglePhotosAccount $account
                 */

                 $result[] = '<option '. ($accountid == $account->getId()?'selected':'') .' value="'.$account->getId().'">'.$account->getName().'</option>';

            }
            $result[] = "</select>";
            $result[] = "<br><br>".Text::_('COM_EVENTGALLERY_FIELD_FOLDERTYPE_GOOGLEPHOTOS_ALBUM')."<br>";
            $result[] = '<input class="form-control" onchange="' . $onchange . '" type="text" id="foldertype-4-album" value="' . $album . '" />';
            $result[] = "<br>";
            $result[] = "<br>";
            $result[] = Text::_('COM_EVENTGALLERY_FIELD_FOLDERTYPE_GOOGLEPHOTOS_ALBUMNAME')."<br>";
            $result[] = '<input class="form-control" disabled="true" onchange="' . $onchange . '"type="text" id="foldertype-4-title" value="' . $title . '" />';
            $result[] = "<br>";
            $result[] = "<br>";



            $result[] = \Joomla\CMS\HTML\HTMLHelper::_(
                'bootstrap.renderModal',
                'google-photos-album-selector-modal',
                array(
                    'title' => Text::_('COM_EVENTGALLERY_EVENT_GOOGLE_PHOTOS_ABLUM_SELECTOR'),
                    'url' =>  Route::_('index.php?option=com_eventgallery&view=googlephotos&layout=albumselector&tmpl=component'),
                    'bodyHeight' => '80',
                    'modalWidth' => '80',
                )
            );

            $result[] = '<span data-bs-toggle="modal" data-bs-target="#google-photos-album-selector-modal" data-toggle="modal" data-target="#google-photos-album-selector-modal" class="btn btn-primary">' . Text::_('COM_EVENTGALLERY_EVENT_GOOGLE_PHOTOS_ABLUM_SELECTOR') . '</span>';
            $result[] = '<div id="foldertype-4-albumselectoriframe" ></div>';
            $googlephotosaccountid = $this->form->getValue('googlephotosaccountid');
            $googlephotostitle = $this->form->getValue('googlephotostitle');
            $result[] = '<input type="hidden" name="jform[googlephotosaccountid]" id="jform_googlephotosaccountid" value="'.$googlephotosaccountid.'">';
            $result[] = '<input type="hidden" name="jform[googlephotostitle]" id="jform_googlephotostitle" value="'.$googlephotostitle.'">';
        }

        $result[] = "<br>";
        $result[] = '</div>';


        return implode('', $result);
    }

    function getGooglePhotosSharedPageInput() {
        $result = Array();
        $folderValue = $this->form->getValue("folder")?:'';
        $urlValue = $this->form->getValue("googlephotossharedpageurl")?:'';
        $result[] = '<div class="foldertype-5 foldertype-input">';
        $result[] = '<br>'. Text::_('COM_EVENTGALLERY_EVENTS_SOURCE_GOOGLEPHOTOS_SHAREDPAGE_FOLDER_TITLE') .'<br>';
        $result[] = '<input class="form-control" onchange="document.getElementById(\'jform_folder\').value=this.value" type="text" id="foldertype-5-foldername" value="'.htmlspecialchars($folderValue, ENT_COMPAT, 'UTF-8').'" />';
        $result[] = $this->renderHelText('COM_EVENTGALLERY_EVENTS_SOURCE_GOOGLEPHOTOS_SHAREDPAGE_FOLDER_DESC');
        $result[] = '</div>';


        $result[] = '<div class="foldertype-5 foldertype-input">';
        $result[] = '<br>'. Text::_('COM_EVENTGALLERY_EVENTS_SOURCE_GOOGLEPHOTOS_SHAREDPAGE_URL_TITLE') .'<br>';
        $result[] = '<input class="form-control" onchange="document.getElementById(\'jform_googlephotossharedpageurl\').value=this.value" type="text" id="foldertype-5-googlephotossharedpageurl" value="'.htmlspecialchars($urlValue, ENT_COMPAT, 'UTF-8').'" />';
        $result[] = $this->renderHelText('COM_EVENTGALLERY_EVENTS_SOURCE_GOOGLEPHOTOS_SHAREDPAGE_URL_DESC');
        $result[] = '</div>';

        $result[] = '<input type="hidden" name="jform[googlephotossharedpageurl]" id="jform_googlephotossharedpageurl" value="'.$urlValue.'">';

        return implode('', $result);
    }

    function getFolderInputField() {
        $result = [];
        $value = $this->form->getValue("folder");
        $result[] = '<input type="hidden" class="required" name="jform[folder]" id="jform_folder" value="'.$value.'">';
        return implode('', $result);

    }

    function renderHelText($key) {
        $result[] = '<small style="display:block" class="form-text text-muted">';
        $result[] = Text::_($key);
        $result[] = '</small>';
        return implode('', $result);
    }

}
