<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FlickrAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\GooglePhotosAccountFactory;
use Svenbluege\Component\Eventgallery\Site\Library\FlickrAccount;
use Svenbluege\Component\Eventgallery\Site\Library\FolderType;
use Svenbluege\Component\Eventgallery\Site\Library\GooglePhotosAccount;

defined('_JEXEC') or die('Restricted access');

class FoldertypelistField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'foldertypelist';

    public function getInput()
    {

        /**
         * @var FolderTypeFactory $foldertypeFactory
         */
        $foldertypeFactory = FolderTypeFactory::getInstance();
        $foldertypes = $foldertypeFactory->getFolderTypes(true);

        $return = Array();

        $return[]  = '<select class="form-select custom-select" name="'.$this->name.'" id="'.$this->id.'">';
        foreach($foldertypes as $foldertype) {
            /**
             * @var FolderType $foldertype
             */

            $this->value==$foldertype->getId()?$selected='selected="selected"':$selected ='';

            $return[] = '<option '.$selected.' value="'.$foldertype->getId().'">'.$foldertype->getDisplayName().'</option>';
        }
        $return[] = "</select>";

        return implode('', $return);
    }
}
