<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;

defined('_JEXEC') or die('Restricted access');

/**
 * a plain dummy so we can get those fields to the database while validating the form agains the data.
 * This fieldtype is needed because for the event source, we put many field into on.
 */
class FormfieldgroupField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'formfieldgroup';


    public function getInput()
    {
        $mode = $this->element->attributes()['data-mode'];

        if ($mode == 'open') {
            $class = $this->element->attributes()['data-class'];
            $result = '<div class="'.$class.'">';
        } else {
            $result = '</div>';
        }
        return $result;
    }



}
