<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;

defined('_JEXEC') or die('Restricted access');

class GooglephotosrefrehtokenField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'googlephotosrefrehtoken';


    public function getInput()
    {

        Backendmedialoader::load();

        $id = $this->form->getValue("id");
        $clientid = $this->form->getValue("clientid");
        $secret = $this->form->getValue("secret");

        $return = Array();

        if (empty($clientid) or empty($secret)) {
            $return[] = Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_REFRESHTOKEN_CLIENT_CREDENTIALS_MISSING_LABEL') ;
        } else {
            $return[] = '<div class="input-group">';
            $return[] = '<button class="google-photos-api-oauth-trigger-button btn active btn-success" data-id="'.$id.'" id="' . $this->id . '-button">' . Text::_('COM_EVENTGALLERY_GOOGLEPHOTOSACCOUNT_REFRESHTOKEN_BUTTON_LABEL') . '</button>';
            $return[] = '<input class="form-control google-photos-api-oauth-input" name="' . $this->name . '" value="' . $this->value . '" id="' . $this->id . '"/>';
            $return[] = '</div>';
        }
        return implode('', $return);
    }

}
