<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeGroupFactory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageTypeGroup;
defined('_JEXEC') or die('Restricted access');

class ImagetypegroupsField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'imagetypegroups';


    public function getInput()
    {
        /**
         * @var ImageTypeGroupFactory $imagetypegroupFactory
         */
        $imagetypegroupFactory = ImageTypeGroupFactory::getInstance();
        $imagetypegroups = $imagetypegroupFactory->getImageTypeGroups(false);

        $id = $this->form->getField('id')->value;

        /**
         * @var ImageTypeGroup $imagetypegroup
         */

        $return  = '<select class="form-select" name="'.$this->name.'" id="'.$this->id.'">';
        $return .= '<option value=""></option>';
        foreach($imagetypegroups as $imagetypegroup) {

            $selected = $imagetypegroup->getId() == $this->value ? 'selected="selected"' : '';

            $return .= '<option '. $selected .'value="'.$imagetypegroup->getId().'">'.$imagetypegroup->getName().'</option>';
        }
        $return .= "</select>";

        return $return;

    }
}
