<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeSetFactory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageType;
defined('_JEXEC') or die('Restricted access');

class ImagetypesField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'imagetypes';


    public function getInput()
    {
        /**
         * @var ImageTypeFactory $imagetypeFactory
         * @var ImageTypeSetFactory $imagetypesetFactory
         */
        $imagetypeFactory = ImageTypeFactory::getInstance();
        $imagetypesetFactory = ImageTypeSetFactory::getInstance();

        $imagetypes = $imagetypeFactory->getImageTypes(false);

        $id = $this->form->getField('id')->value;

        $imagetypeset = null;
        if ($id!=0) {
            $imagetypeset = $imagetypesetFactory->getImagetypesetById($id);
        }

        /**
         * @var ImageType $imagetype
         */
        $return  = '<select size="'.count($imagetypes).'" class="form-select" multiple name="'.$this->name.'" id="'.$this->id.'">';
        if ($imagetypeset != null) {
            foreach($imagetypeset->getImageTypes() as $imagetype) {
                $return .= '<option selected="selected" value="'.$imagetype->getId().'">'.$imagetype->getName().'</option>';
            }
        }

        foreach($imagetypes as $imagetype) {
            if ($imagetypeset != null && $imagetypeset->getImageType($imagetype->getId())!=null){
                continue;
            }
            $return .= '<option value="'.$imagetype->getId().'">'.$imagetype->getName().'</option>';
        }
        $return .= "</select>";

        return $return;

    }
}
