<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeSetFactory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageType;
defined('_JEXEC') or die('Restricted access');

class ImagetypesdefaultField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'imagetypesdefault';


    public function getInput()
    {
        /**
         * @var ImageTypeFactory $imagetypeFactory
         * @var ImageTypeSetFactory $imagetypesetFactory
         */
        $imagetypeFactory = ImageTypeFactory::getInstance();
        $imagetypesetFactory = ImageTypeSetFactory::getInstance();


        $imagetypes = $imagetypeFactory->getImageTypes(false);

        $id = $this->form->getField('id')->value;

        $imagetypeset = null;
        if ($id!=0) {
            $imagetypeset = $imagetypesetFactory->getImagetypesetById($id);
        }

        /**
         * @var ImageType $imagetype
         */

        $return = '<select class="form-select" name="'.$this->name.'" id="'.$this->id.'">';
        $defaultid = -1;
        if ($imagetypeset != null && $imagetypeset->getDefaultImageType()){
            $defaultid = $imagetypeset->getDefaultImageType()->getId();
        }

        foreach($imagetypes as $imagetype) {

            $imagetype->getId()==$defaultid?$selected='selected="selected"':$selected='';

            $return .= '<option '.$selected.' value="'.$imagetype->getId().'">'.$imagetype->getName().'</option>';
        }
        $return .= "</select>";

        return $return;

    }
}
