<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeSetFactory;
use Svenbluege\Component\Eventgallery\Site\Library\ImageTypeSet;
defined('_JEXEC') or die('Restricted access');

class ImagetypesetField extends FormField
{
    //The field class must know its own type through the variable $type.
    protected $type = 'imagetypeset';

    public function getInput()
    {
        /**
         * @var ImageTypeSetFactory $imagetypesetFactory
         */

        $imagetypesetFactory = ImageTypeSetFactory::getInstance();

        $imagetypesets = $imagetypesetFactory->getImageTypeSets(true);
        $showForFile = $this->getAttribute('showforfile');

        if (!$showForFile) {
            if ($this->value == null && $imagetypesetFactory->getDefaultImageTypeSet(false) != null) {
                $this->value = $imagetypesetFactory->getDefaultImageTypeSet(false)->getId();
            }
        }

        $return  = '<select class="form-select" name='.$this->name.' id='.$this->id.'>';

        if ($showForFile) {
            $return .= '<option value="-1">' . \Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_FILE_IMAGETYPESET_USE_PARENT') . '</option>';
        }

        foreach($imagetypesets as $imagetypeset) {
            /**
             * @var ImageTypeSet $imagetypeset
             */

            $this->value==$imagetypeset->getId()?$selected='selected="selected"':$selected ='';

            $return .= '<option '.$selected.' value="'.$imagetypeset->getId().'">'.$imagetypeset->getName().'</option>';
        }
        $return .= "</select>";
        return $return;

    }
}
