<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Form\Field\EditorField;

defined('_JEXEC') or die('Restricted access');

class LocalizableeditorField extends EditorField
{

    //The field class must know its own type through the variable $type.
    public $type = 'localizableeditor';
    protected $editorType = NULL;


    public function getInput()
    {
        $result = "";
        $langs = \Joomla\CMS\Language\LanguageHelper::getKnownLanguages();
        $oldId = $this->id;
        $oldName = $this->name;
        $oldValue = $this->value;

        $lt = json_decode($oldValue);

        if ($lt == null) {
            $lt = new \stdClass();
            // added fallback logic in case the current value is not in JSON format
            // this might be because in older versions there where no multilanguage fields.
            if (!empty($this->value) && json_last_error() == JSON_ERROR_SYNTAX) {
                foreach($langs as $tag=>$lang) {
                    $lt->$tag = $this->value;
                }
            }
        }

        $defaultLanguageTag = ComponentHelper::getParams('com_languages')->get('site');
        $defaultLanguage = $langs[$defaultLanguageTag];
        if ($defaultLanguage != null) {
            unset($langs[$defaultLanguageTag]);
            $langs = array_merge(array($defaultLanguageTag => $defaultLanguage), $langs);
        }

        if (count($langs)>1) {
            $result .= '<small>'.\Joomla\CMS\Language\Text::_('COM_EVENTGALLERY_LOCALIZEDEDITOR_WARNING').'</small>';
        }

        foreach($langs as $tag=>$lang) {
            $defaultLangMarker = $tag == $defaultLanguageTag? "*": "";
            $this->value = isset($lt->$tag)===true?$lt->$tag:'';
            $this->id = $oldId . str_replace('-','_',$tag);
            $this->name = $oldName . str_replace('-','_',$tag);
            $result .= '<div style="clear:both">';
            $result .= "<h4 >$tag $defaultLangMarker</h4>";
            $result .= parent::getInput();
            $result .= '</div>';
        }
        $this->id = $oldId;
        $this->value=$oldValue;
        $this->name = $oldName;

        $hiddenField =  '<input type="hidden" name="' . $this->name . '" id="' . $this->id . '" value="' . htmlspecialchars($this->value, ENT_COMPAT, 'UTF-8') . '"/>';

        $codeForSaving = "";



        $getValuesCode = "";
        foreach ($langs as $tag => $lang) {
            $lcFieldid = $oldId . str_replace('-', '_', $tag);
            $getValuesCode .= <<<TAG
            value = Joomla.editors.instances.$lcFieldid.getValue();
            if (value && value.trim().length > 0) {
                data['$tag'] = value;
            }                        
TAG;
        }


        $codeForSaving = <<<TAG

        <script> 
            document.addEventListener('DOMContentLoaded', (event) => {
                var elements = document.getElementsByTagName('FORM');
                for (var i=0; i<elements.length; i++) {
                    elements[i].addEventListener('submit', function(e) {

                        var data = {},
                            value,
                            jsonData;
    
                        $getValuesCode
    
                        jsonData = JSON.stringify(data);
                        if (jsonData.length < 3) {
                            jsonData = "";
                        }
                        
                        document.getElementById("{$this->id}").value = jsonData;

                    });
                }
            });
        </script>
TAG;

        return $result.$hiddenField.$codeForSaving;
    }
}
