<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Plugin\PluginHelper;
use JPluginHelper;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;
use RecursiveRegexIterator;
use RegexIterator;

defined('_JEXEC') or die('Restricted access');


// The class name must always be the same as the filename (in camel case)
/**
 * provides a form field where you can select which class should be used. This works only of the ID is not set.
 *
 * Class JFormFieldmethodsclass
 */
class MethodsclassField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'methodsclass';


    public function getInput()
    {

        $plugins = PluginHelper::getPlugin((string)$this->element['plugin_folder']);

        $workingClasses = [];

        $app = Factory::getApplication();
        foreach($plugins as $plugin) {
            $bootedPlugin = $app->bootPlugin($plugin->name, $plugin->type);
            if (method_exists($bootedPlugin, 'getWorkingClass')) {
                $workingClasses[] = $bootedPlugin->getWorkingClass();
            }
        }

        $required = $this->required ? ' required="required" aria-required="true"' : '';
        $cssclass = $this->element['class'] ? ' class="form-select ' . (string) $this->element['class'] . '"' : 'form-select';

        if ($this->form->getField('id')->value!=0 && $this->value!="") {
            $class= $this->value;

            if ( class_exists($class ) ) {
                $classname = $class::getClassName();
            } else {
                $classname = 'invalid';
            }

            return  '<input '.$cssclass.' value="'.$classname.'" disabled="disabled"">';
        }

        $return  = '<select '.$required.' '.$cssclass.' name='.$this->name.' id='.$this->id.'>';
        foreach($workingClasses as $class) {
            $return .= '<option value="'.$class.'">'.$class::getClassName().'</option>';
        }
        $return .= "</select>";

        return $return;

    }

    private function getClasses($path) {
        $directory = new RecursiveDirectoryIterator($path);
        $iterator = new RecursiveIteratorIterator($directory);
        // filer for the second subdirectory like /home/foo/xxxx/yyy.php
        $dirSep = '\\/\\\\';
        $regex = new RegexIterator($iterator, '/^'.preg_quote($path, '/')."[$dirSep][^$dirSep]+[$dirSep][^$dirSep]+\\.php$/i", RecursiveRegexIterator::GET_MATCH);
        foreach($regex as $object) {
            require_once($object[0]);
        }
    }


}
