<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderStatusFactory;
use Svenbluege\Component\Eventgallery\Site\Library\OrderStatus;

defined('_JEXEC') or die('Restricted access');

class OrderstatustypesField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'orderstatustypes';
    protected $currentOrderstatusId = OrderStatus::TYPE_ORDER;

    public function getInput()
    {
        /**
         * @var OrderStatusFactory $orderstatusFactory
         */
        $orderstatusFactory = OrderStatusFactory::getInstance();

        $statuses = $orderstatusFactory->getOrderStatuses($this->currentOrderstatusId);

        if ($this->value == null) {
            $this->value = $orderstatusFactory->getDefaultOrderStatus($this->currentOrderstatusId)->getId();
        }


        $currentorderstatus = $orderstatusFactory->getOrderStatusById($this->value);

        $return = "";
        $return .= '<select class="form-select" name='.$this->name.' id='.$this->id.'>';
        foreach($statuses as $orderstatus) {
            /**
             * @var OrderStatus $orderstatus
             */

            $this->value==$orderstatus->getId()?$selected='selected="selected"':$selected ='';

            $return .= '<option '.$selected.' value="'.$orderstatus->getId().'">'.$orderstatus->getDisplayName().'</option>';
        }
        $return .= "</select>";
        $return .= "<br><small>". ($currentorderstatus ? $currentorderstatus->getDisplayName() : 'n/a')."</small>";
        return $return;

    }
}
