<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Svenbluege\Component\Eventgallery\Administrator\Helper\Backendmedialoader;
defined('_JEXEC') or die('Restricted access');

class ScalepriceeditorField extends FormField
{
    //The field class must know its own type through the variable $type.
    protected $type = 'scalepriceeditor';

    public function getInput()
    {
        Backendmedialoader::load();

        $value = $this->value;
        if (empty($this->value)) {
            $value = '{}';
        }
        return '<span class="scale-price-editor"><input type="text" value="'. htmlspecialchars($value, ENT_QUOTES, 'UTF-8') .'" id='.$this->id.' name="'. $this->name .'"></span>';
    }




}
