<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Field;
use Joomla\CMS\Form\FormField;
use Joomla\CMS\Language\Text;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\WatermarkFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Watermark;

defined('_JEXEC') or die('Restricted access');



// The class name must always be the same as the filename (in camel case)
class WatermarkField extends FormField
{

    //The field class must know its own type through the variable $type.
    protected $type = 'watermark';


    public function getInput()
    {
         /**
         * @var WatermarkFactory $watermarkFactory
         */
        $watermarkFactory = WatermarkFactory::getInstance();

        $watermarks = $watermarkFactory->getWatermarks(false);

        $return  = '<select class="form-select" name='.$this->name.' id='.$this->id.'>';
        $return .= '<option  value="-1">'.Text::_('COM_EVENTGALLERY_WATERMARK_NONE').'</option>';

        foreach($watermarks as $watermark) {
            /**
             * @var Watermark $watermark
             */

            $this->value==$watermark->getId()?$selected='selected="selected"':$selected ='';

            $return .= '<option '.$selected.' value="'.$watermark->getId().'">'.$watermark->getName().'</option>';
        }
        $return .= "</select>";
        return $return;

    }
}
