<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Helper;
use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class Backendmedialoader
{

    static $loaded = false;

    public static function load()
    {

        if (self::$loaded) {
            return;
        }

        if (!defined('EVENTGALLERY_VERSION')) {
            Factory::getApplication()->bootComponent('com_eventgallery');
        }

        self::$loaded = true;

        $document = Factory::getDocument();

        HTMLHelper::_('behavior.formvalidator');

        // Add the modal field script to the document head.
        HTMLHelper::_('script', 'system/fields/modal-fields.min.js', array('version' => 'auto', 'relative' => true));


        $CSSs = Array();
        $JSs = Array();

        $JSs[] = 'dist/backend.js';

        $CSSs[] = 'dist/backend.css';


        $CSSs[] = 'backend/css/joomla4.css';
        $CSSs[] = 'backend/css/breakpoint-editor.css';


        $JSs = array_merge($JSs, Array(
        ));

        foreach($CSSs as $css) {
            $script = Uri::root() . 'media/com_eventgallery/'.$css.'?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
            $document->addStyleSheet($script);
        }

        foreach($JSs as $js) {
            $script = Uri::root() . 'media/com_eventgallery/'.$js.'?v=' . EVENTGALLERY_VERSION . '&e=' . EVENTGALLERY_EXTENDED;
            $document->addScript($script);
        }

        $googlePhotosConfiguration = Array();
        $googlePhotosConfiguration['albumUrl'] = str_replace('administrator/', '', Route::_('index.php?option=com_eventgallery&view=googlephotosapi&task=getAlbum&format=raw', false));
        $googlePhotosConfiguration['albumsUrl'] = str_replace('administrator/', '', Route::_('index.php?option=com_eventgallery&view=googlephotosapi&task=getAlbums&format=raw', false));

        $document->addScriptDeclaration("window.EventGalleryGooglePhotosConfiguration=" . json_encode($googlePhotosConfiguration) . ";");

    }

}



