<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Library\Common;
use Joomla\CMS\Application\ApplicationHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\Filesystem\Path;

defined('_JEXEC') or die();

class View extends \Joomla\CMS\MVC\View\HtmlView
{

    // a static field to avoid multiple lookups for templates.
    // it should be enough if we found them once
    private static $templateCache = null;

    /**
     * The constructor of this class
     *
     * @param array $config
     */
    public function __construct($config = array())
    {
        // initialize the cache if this did not happen before
        if (self::$templateCache == null) {
            self::$templateCache = Array();
        }

        if (array_key_exists('site_template', $config))
        {
            $this->_site_template = $config['site_template'];
        }
        else
        {
            $this->_site_template = null;
        }

        parent::__construct($config);
    }

    /**
     * Loads a snippet from the snippets folder. Name can contain a slash:
     *  foo/bar will load component/tmpl/snippets/foo/bar.php
     *
     * @param string $tpl
     *
     * @return string the output of the template
     * @throws \Exception
     */
    public function loadSnippet($tpl)
    {
        // Clear prior output
        $this->_output = null;

        // create a hash of the template to avoid conflicts with the array key in the cache
        $cacheKey = md5($tpl);

        // Clean the file name
        $file = preg_replace('/[^A-Z0-9_\.-\/]/i', '', $tpl);

        // if the cache is not filled for the current template try to get it.
        if ( !isset(self::$templateCache[$cacheKey]) ) {

            $baseDir = $this->_basePath . '/tmpl/snippets';
            $component = ApplicationHelper::getComponentName();
            $app = Factory::getApplication();
            $component = preg_replace('/[^A-Z0-9_\.-]/i', '', $component);

            if ($this->_site_template != null) {
                $fallback = JPATH_SITE . '/templates/' . $this->_site_template . '/html/' . $component . '/' . 'snippets';
            } else {
                $fallback = JPATH_THEMES . '/' . $app->getTemplate() . '/html/' . $component . '/' . 'snippets';
            }


            $path = array($fallback, $baseDir);

            // Load the template script

            $filetofind = $this->_createFileName('template', array('name' => $file));
            self::$templateCache[$cacheKey] = Path::find($path, $filetofind);
        }

        // get the template from the cache
        $template = self::$templateCache[$cacheKey];


        // If alternate layout can't be found, fall back to default layout
        if ($template == false)
        {
            throw new \Exception(\Joomla\CMS\Language\Text::sprintf('JLIB_APPLICATION_ERROR_LAYOUTFILE_NOT_FOUND', $file), 500);
        }


        // Unset so as not to introduce into template scope
        unset($tpl);
        unset($file);

        // Never allow a 'this' property
        if (isset($this->this))
        {
            unset($this->this);
        }

        // Start capturing output into a buffer
        ob_start();

        // Include the requested template filename in the local scope
        // (this will execute the view logic).
        include $template;

        // Done with the requested template; get the buffer and
        // clear it.
        $this->_output = ob_get_contents();
        ob_end_clean();

        return $this->_output;


    }

    public function renderMessages()
    {
        // Get the message queue
        $messages = Factory::getApplication()->getMessageQueue();

        $lists = array();

        // Build the sorted message list
        if (is_array($messages) && !empty($messages)) {
            foreach ($messages as $msg) {
                if (isset($msg['type']) && isset($msg['message'])) {
                    $lists[$msg['type']][] = $msg['message'];
                }
            }
        }

        $displayData = array(
            'msgList' => $lists,
            'name' => '',
            'params' => '',
            'content' => ''
        );

        return LayoutHelper::render('joomla.system.message', $displayData);
    }


}
