<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Library\Csv;
class CsvEntry {
    private $folder;
    private $file;
    private $type;
    private $created;
    private $joomlaUserId;
    private $joomlaUserEmail;
    private $orderId;
    private $orderEmail;

    public function __construct($folder, $file, $type, $created, $joomlaUserId, $joomlaUserEmail, $orderId, $orderEmail)
    {
        $this->folder = $folder;
        $this->file = $file;
        $this->type = $type;
        $this->created = $created;
        $this->joomlaUserId = $joomlaUserId;
        $this->joomlaUserEmail = $joomlaUserEmail;
        $this->orderId = $orderId;
        $this->orderEmail = $orderEmail;
    }

    public static function getCSVHeadline() {
        return [
            "Folder",
            "File",
            "Type",
            "Is Bot",
            "Created",
            "Joomla User Id",
            "Joomla User",
            "Order DocumentNo",
            "Order Email"
        ];
    }

    public function getCSVLine() {
        return [
            $this->folder,
            $this->file,
            $this->type,
            $this->created,
            $this->joomlaUserId,
            $this->joomlaUserEmail,
            $this->orderId,
            $this->orderEmail
        ];
    }
}
