<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use DateTime;
use Joomla\CMS\MVC\Model\ListModel;

defined('_JEXEC') or die();



class DownloadlogModel extends ListModel
{

    protected $context = '';

    /**
     * Translate the month into something readable.
     *
     * @param $month
     * @return int|string
     */
    public static function monthToString($month) {
        switch($month) {
            case 13: return 'Q1'; break;
            case 14: return 'Q2'; break;
            case 15: return 'Q3'; break;
            case 16: return 'Q4'; break;
            case 17: return 'Year'; break;
            default: $dateObj   = \DateTime::createFromFormat('!m', $month); return $dateObj->format('F'); // March; break;
        }
    }

    /**
     * A month can be something between 1 and 17. 13-17 have special meanings.
     *
     * translates a given month into a comma separated list of month 1-12
     *
     * @param $month
     * @return int|string
     */
    public static function getMonthCondition($month) {
        switch($month) {
            case 13: return '1,2,3'; break;
            case 14: return '4,5,6'; break;
            case 15: return '7,8,9'; break;
            case 16: return '10,11,12'; break;
            case 17: return '1,2,3,4,5,6,7,8,9,10,11,12'; break;
            default: return (int) $month; break;
        }
    }

    /**
     * Returns the query
     * @return string The query to be used to retrieve the rows from the database
     */
    function getListQuery()
    {

        // Create a new query object.
        /**
         * @var Joomla\Database\DatabaseDriver $db
         */
        $db = $this->getDbo();
        $query = $db->getQuery(true);
        $query->select('dl.*, u.id as juserid');
        $query->from('#__eventgallery_downloadlog dl');
        $query->join('LEFT','#__users u on dl.userid=u.id');

        // Filter by type
        $filtertypeid = $this->getState('filter.type', null);
        if (!empty($filtertypeid) && $filtertypeid!='*')
        {
            $query->where('dl.type = '. $db->quote($filtertypeid));
        }

        $filteryear = $this->getState('filter.year', null);
        if (!empty($filteryear) && $filteryear!='*')
        {
            $query->where('YEAR(dl.created) = '. (int)$filteryear);
        }

        $filtermonth = $this->getState('filter.month', null);
        if (!empty($filtermonth) && $filtermonth!='*')
        {
            $query->where('MONTH(dl.created) in (' . self::getMonthCondition($filtermonth) .')');
        }

        $filterusertype = $this->getState('filter.usertype', false);
        if ($filterusertype == 'reg')
        {
            $query->where('not u.id is null');
        }
        if ($filterusertype == 'guest')
        {
            $query->where('u.id is null');
        }

        $filterisbot = $this->getState('filter.isbot', false);
        if ($filterisbot === 'yes')
        {
            $query->where('dl.isbot = 1');
        }
        if ($filterisbot === 'no')
        {
            $query->where('dl.isbot = 0');
        }

        $query->order('created desc');

        return $query;
    }

    /**
     * Method to auto-populate the model state.
     *
     * Note. Calling getState in this method will result in recursion.
     *
     * @since   1.6
     * @param null $ordering
     * @param null $direction
     */
    protected function populateState($ordering = null, $direction = null)
    {
        // Load the filter state.
        $search = $this->getUserStateFromRequest($this->context.'.filter.type', 'filter_type');
        $this->setState('filter.type', $search);

        $search = $this->getUserStateFromRequest($this->context.'.filter.year', 'filter_year');
        $this->setState('filter.year', $search);

        $search = $this->getUserStateFromRequest($this->context.'.filter.month', 'filter_month');
        $this->setState('filter.month', $search);

        $search = $this->getUserStateFromRequest($this->context.'.filter.usertype', 'filter_usertype');
        $this->setState('filter.usertype', $search);

        $search = $this->getUserStateFromRequest($this->context.'.filter.isbot', 'filter_isbot');
        $this->setState('filter.isbot', $search);

        parent::populateState('created', 'desc');
    }

    /**
     * Method to get a store id based on model configuration state.
     *
     * This is necessary because the model is used by the component and
     * different modules that might need different sets of data or different
     * ordering requirements.
     *
     * @param   string  $id	A prefix for the store id.
     * @return  string  A store id.
     * @since   1.6
     */
    protected function getStoreId($id = '')
    {
        // Compile the store id.
        $id .= ':' . $this->getState('filter.type');
        $id .= ':' . $this->getState('filter.year');
        $id .= ':' . $this->getState('filter.month');
        $id .= ':' . $this->getState('filter.usertype');
        $id .= ':' . $this->getState('filter.isbot');

        return parent::getStoreId($id);
    }
}
