<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;
use Joomla\Registry\Registry;
use Svenbluege\Component\Eventgallery\Administrator\Table\EmailtemplateTable;
use Svenbluege\Component\Eventgallery\Site\Library\Manager\EmailTemplateManager;
defined('_JEXEC') or die();

class EmailtemplateModel extends AdminModel
{

    public function getItem($pk = null) {
        $app = Factory::getApplication();

        /**
         * @var EmailtemplateTable $item
         */
        $item = parent::getItem($pk);

        if ($item!== false) {
            // Convert the params field to an array.
            $registry = new Registry($item->attachments);
            $item->attachments = $registry->toArray();
        }

        $item->renderedSubject = '';
        $item->renderedBody = '';
        $item->demodata = Array();

        /**
         * @var EmailTemplateManager $emailtemplateMgr
         */
        $emailtemplateMgr = EmailTemplateManager::getInstance();


        $loadDefault = $app->input->getCmd('loaddefault') == 'true';

        if (!empty($item->key)) {

            if (empty(trim($item->body)) || $loadDefault) {
                $item->body = $emailtemplateMgr->getDefaultBody($item->key);
            }

            if (empty(trim($item->subject)) || $loadDefault) {
                $item->subject = $emailtemplateMgr->getDefaultSubject($item->key);
            }

            $item->demodata = $emailtemplateMgr->getDemoData($item->key);
        }

        return $item;
    }


    public function getForm($data = array(), $loadData = true) {

        $form = $this->loadForm('com_eventgallery.emailtemplate', 'emailtemplate', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)){
            return false;
        }

        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.emailtemplate.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

		if (method_exists($this, 'preprocessData')) {
        	$this->preprocessData('com_eventgallery.emailtemplate', $data);
        }

        return $data;
    }

}
