<?php

/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;

use Joomla\CMS\Factory;
use Joomla\Database\ParameterType;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Folder\Folder;

defined('_JEXEC') or die();



class FilesModel extends \Joomla\CMS\MVC\Model\ListModel
{

    /**
     * @var \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main
     */
    protected $config;
    protected $_id = null;
    protected $_item = null;

    public function __construct() {
        $app = Factory::getApplication();
        $ids = $app->input->getString('folderid');
        $this->_id = $ids;
        $this->config = \Svenbluege\Component\Eventgallery\Site\Library\Configuration\Main::getInstance();
        parent::__construct();
    }

	function getListQuery()
	{
		// Create a new query object.
        $db = $this->getDbo();
        $query = $db->getQuery(true);

		$query->select('file.*');

		$query->from('#__eventgallery_file AS file');
        $query->join('','#__eventgallery_folder AS folder on folder.folder=file.folder');
		$query->where('folder.id='.$this->_db->quote($this->_id));
		$query->group('file.id');

        $sortAttribute = $this->getItem()->getSortAttribute();
        $sortDirection = $this->getItem()->getSortDirection();

        if (empty($sortAttribute)) {
            $sortAttribute = $this->config->getEventsList()->getSortFilesByColumn();
        }
        if (empty($sortDirection)) {
            $sortDirection = $this->config->getEventsList()->getSortFilesByDirection();
        }

        $sortBy = "";
        if (!empty($sortAttribute)) {
            $sortBy = $db->quoteName($sortAttribute) . ' ' . (strtoupper($sortDirection) == 'ASC'?'ASC':'DESC') . ',';
        }


        // find files which are allowed to show in a list
        $query->order($sortBy . 'ordering DESC, file.file');

		return $query;
	}

    /**
     * @return Folder
     */
    function getItem()
    {
        if (empty( $this->_item )) {
            /**
             * @var FolderFactory $folderMgr
             */
            $folderMgr = FolderFactory::getInstance();
            $this->_item = $folderMgr->getFolderById($this->_id);
        }

        return $this->_item;
    }

    function resetHits($folderid) {
        $folderMgr = FolderFactory::getInstance();
        $folder = $folderMgr->getFolderById($folderid);
        $db = $this->getDbo();

        $query = $db->getQuery(true)
            ->update('#__eventgallery_file')
            ->set('hits=0')
            ->where('folder=:folder')
            ->bind(':folder', $folder->getFolderName(), ParameterType::STRING);

        $db->setQuery( $query );
        $db->execute();
    }


}
