<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\CartFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\OrderFactory;

defined('_JEXEC') or die();

class GdprModel  extends ListModel
{
    /**
     * @param $email
     * @return array
     */
    public function getCarts($email) {
        /**
         * @var CartFactory $cartFactory
         */
        $cartFactory = CartFactory::getInstance();
        return $cartFactory->getCartsByEmail($email);
    }

    /**
     * @param $email
     * @return array
     */
    public function getOrders($email) {
        /**
         * @var OrderFactory $orderFactory
         */
        $orderFactory = OrderFactory::getInstance();

        return $orderFactory->getOrdersByEmail($email);
    }

    /**
     * @param $email
     * @return array
     */
    public function getUsers($email) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);

        $query->select('id')->from('#__users')->where('email='.$db->quote($email));

        $db->setQuery($query);
        $dbUserIds = $db->loadColumn(0);

        $users = [];
        foreach($dbUserIds as $userId) {
            array_push($users, Factory::getUser($userId));
        }

        return $users;
    }
}
