<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\AdminModel;

defined('_JEXEC') or die();

class ImagetypegroupModel extends AdminModel
{
    protected $text_prefix = 'COM_EVENTGALLERY';


    /**
     * Method to get the record form.
     *
     * @param array $data An optional array of data for the form to interogate.
     * @param boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return JForm A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Initialise variables.

        // Get the form.
        $form = $this->loadForm('com_eventgallery.imagetypegroup', 'imagetypegroup', array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)) {
            return false;
        }
        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.imagetypegroup.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

		if (method_exists($this, 'preprocessData')) {
        	$this->preprocessData('com_eventgallery.imagetypegroup', $data);
		}

        return $data;
    }

    public function delete(&$pks) {
        if (!parent::delete($pks)) {
            return false;
        }


        foreach($pks as $pk) {
            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update('#__eventgallery_imagetype');
            $query->set("imagetypegroupid = null");
            $query->where('imagetypegroupid = '.$db->quote($pk));
            $db->setQuery($query);
            $db->execute();
        }

        return true;

    }









}
