<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\MVC\Model\ListModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\ImageTypeFactory;
defined('_JEXEC') or die();

class ImagetypesModel extends ListModel
{

    protected $context = '';

	function __construct()
	{
	    parent::__construct();
	}

	/**
	 * Returns the query
	 * @return string The query to be used to retrieve the rows from the database
	 */
	function getListQuery()
	{

		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('*');
		$query->from('#__eventgallery_imagetype');

		return $query;
	}


    protected function _getList($query, $limitstart = 0, $limit = 0)
    {
        /**
         * @var ImageTypeFactory $imagetypeFactory
         */
        $imagetypeFactory = ImageTypeFactory::getInstance();

        $this->_db->setQuery($query, $limitstart, $limit);
        $result = $this->_db->loadObjectList();

        $objects = array();
        foreach($result as $item) {
           array_push($objects, $imagetypeFactory->getImagetypeById($item->id));
        }

        return $objects;
    }
}
