<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\BaseModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FileFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\FolderFactory;
defined('_JEXEC') or die();

class JsonModel extends BaseModel
{

    /**
     * loads all folders we have and returns them as Folder in an array
     *
     * @return array
     */
    function getFolders() {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('folder')->from('#__eventgallery_folder');
        $db->setQuery($query);
        $rows = $db->loadObjectList();
        $folders = [];

        /**
         * @var FolderFactory $folderFactory
         */
        $folderFactory = FolderFactory::getInstance();
        foreach($rows as $row) {
            $folders[] = $folderFactory->getFolder($row->folder);
        }
        return $folders;
    }

    /**
     * loads all files of an event and returns them as File in an array
     *
     * @return \Svenbluege\Component\Eventgallery\Site\Library\File\File[]
     */
    function getFiles($foldername) {
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select('folder, file')->from('#__eventgallery_file')->where('folder='.$db->quote($foldername));
        $db->setQuery($query);
        $rows = $db->loadObjectList();
        $files = [];

        /**
         * @var \Svenbluege\Component\Eventgallery\Site\Library\File\File $fileFactory
         */
        $fileFactory = FileFactory::getInstance();
        foreach($rows as $row) {
            $files[] = $fileFactory->getFile($row->folder, $row->file);
        }
        return $files;
    }
}
