<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\MVC\Model\AdminModel;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\MethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Interface\Method;
defined('_JEXEC') or die();

class MethodModel extends AdminModel
{
    protected $text_prefix = 'COM_EVENTGALLERY';
    protected $table_type = null;
    protected $table_name = null;
    protected $form_name = null;
    protected $form_source = null;
    /**
     * @var MethodFactory
     */
    protected $methodFactory = null;

    /**
     * Method to get the record form.
     *
     * @param array $data An optional array of data for the form to interogate.
     * @param boolean $loadData True if the form is to load its own data (default case), false if not.
     * @return JForm A JForm object on success, false on failure
     */
    public function getForm($data = array(), $loadData = true)
    {
        // Initialise variables.

        // Get the form.
        /**
         * @var Form $form
         */
        $form = $this->loadForm($this->form_name, $this->form_source, array('control' => 'jform', 'load_data' => $loadData));

        if (empty($form)) {
            return false;
        }

        if ($form->getValue('id')!=0 || isset($data['id'])) {
            /**
             * @var Svenbluege\Component\Eventgallery\Site\Library\Interface\Method $method
             */

            $id = $form->getValue('id');
            if (isset($data['id'])) {
                $id = $data['id'];
            }
            $method = $this->methodFactory->getMethodById($id, false);
            if ($method) {
                $form = $method->onPrepareAdminForm($form);
            }
        }

        return $form;
    }

    protected function loadFormData()
    {
        // Check the session for previously entered form data.
        $data = Factory::getApplication()->getUserState('com_eventgallery.edit.'.$this->form_name.'.data', array());

        if (empty($data))
        {
            $data = $this->getItem();
        }

		if (method_exists($this, 'preprocessData')){
        	$this->preprocessData($this->form_source, $data);
		}

        return $data;
    }

    public function setDefault($pks, $value) {

        $id = $pks[0];
        if ($value==1) {

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update($db->qn($this->table_name));
            $query->set($db->quoteName('default') . ' = 0');
            $db->setQuery($query);
            $db->execute();

            $db = Factory::getDbo();
            $query = $db->getQuery(true);
            $query->update($db->qn($this->table_name));
            $query->set($db->quoteName('default') . ' = 1');
            $query->where('id='.$db->quote($id));

            $db->setQuery($query);
            $db->execute();

        }
        return true;

    }

    public function save($data) {
        $success = parent::save($data);
        $this->methodFactory->clearCache();
        if (isset($data['id'])) {
            /**
             * @var Method $method
             */

            $method = $this->methodFactory->getMethodById($data['id'], false);
            if ($method) {
                $success &= $method->onSaveAdminForm($data);
            }
        }

        return $success;
    }


    protected function prepareTable($table)
    {
        // Set ordering to the last item if not set
        if (empty($table->ordering))
        {
            $db = $this->getDbo();
            $query = $db->getQuery(true)
                ->select('MAX(ordering)')
                ->from($this->table_name);

            $db->setQuery($query);
            $max = $db->loadResult();

            $table->ordering = $max + 1;
        }
    }




}
