<?php
/**
 * @package     Sven.Bluege
 * @subpackage  com_eventgallery
 *
 * @copyright   Copyright (C) 2005 - 2019 Sven Bluege All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
namespace Svenbluege\Component\Eventgallery\Administrator\Model;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\ListModel;
use Joomla\CMS\Plugin\PluginHelper;
use Svenbluege\Component\Eventgallery\Site\Library\Factory\MethodFactory;
use Svenbluege\Component\Eventgallery\Site\Library\Methods\DummyMethod;
defined('_JEXEC') or die();

abstract class MethodsModel extends ListModel
{
    /**
     * @var MethodFactory
     */
    protected $methodFactory = null;
    protected $context = '';
    protected $table_name = null;
    protected $plugin_folder = '';

	/**
	 * Returns the query
	 * @return string The query to be used to retrieve the rows from the database
	 */
	function getListQuery()
	{

		// Create a new query object.
		$db = $this->getDbo();
		$query = $db->getQuery(true);

		$query->select('*');
		$query->from($db->qn($this->table_name));
		$query->order('ordering');

		return $query;
	}


    protected function _getList($query, $limitstart = 0, $limit = 0)
    {
        $this->_db->setQuery($query, $limitstart, $limit);
        $result = $this->_db->loadObjectList();

        $objects = array();

        foreach($result as $item) {
            $app = Factory::getApplication();
            $workingClass = \Svenbluege\Component\Eventgallery\Site\Library\Helper\PluginHelper::findWorkingClass($app, $this->plugin_folder, $item->classname);

            // if the class does not exist, we create a dummy method
            if (!class_exists($item->classname)) {
               $objects[] = new DummyMethod($item);
               $app->enqueueMessage(Text::sprintf('COM_EVENTGALLERY_METHOD_CLASSNAME_INVALID',$item->id, $item->name, $item->classname), 'error');
               continue;
           }

           // if the plugin is not enabled, we create a dummy method
           if ($workingClass == null) {
               $objects[] = new DummyMethod($item);
               $app->enqueueMessage(Text::sprintf('COM_EVENTGALLERY_METHOD_CLASSNAME_NOT_FOUND',$item->id, $item->name), 'error');
               continue;
           }

           $objects[] = $this->methodFactory->getMethodById($item->id, false);
        }

        return $objects;
    }

}
